/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.ApiKeysVersionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.metrics.AbstractSensorBuilder;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class ApiKeysVersionSensorBuilder
extends AbstractSensorBuilder<TenantMetrics.ApiKeysVersionContext, ApiKeysVersionSensors> {
    public static final String API_KEYS_MAX_VERSION_SENSOR_NAME = "api-keys-max-version";
    private static final Map<String, AbstractSensorCreator> SENSOR_CREATORS = new HashMap<String, AbstractSensorCreator>();

    public ApiKeysVersionSensorBuilder(Metrics metrics, ApiKeys apikey) {
        super(metrics, (MetricsBuilderContext)new TenantMetrics.ApiKeysVersionContext(apikey));
    }

    public ApiKeysVersionSensors build() {
        Map sensors = this.getOrCreateSuffixedSensors();
        return new ApiKeysVersionSensors((Sensor)sensors.get(API_KEYS_MAX_VERSION_SENSOR_NAME));
    }

    protected String sensorSuffix(String name, TenantMetrics.ApiKeysVersionContext context) {
        return context.sensorSuffix();
    }

    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        return SENSOR_CREATORS;
    }

    protected <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> sensorCreators, T sensorKey, String sensorName) {
        ApiKeysVersionSensors.ApiKeysVersionSensorCreator sensorCreator = (ApiKeysVersionSensors.ApiKeysVersionSensorCreator)sensorCreators.get(sensorKey);
        return sensorCreator.createSensor(this.metrics, sensorName, (TenantMetrics.ApiKeysVersionContext)this.context);
    }

    static {
        SENSOR_CREATORS.put(API_KEYS_MAX_VERSION_SENSOR_NAME, new ApiKeysVersionSensors.ApiKeysVersionSensorCreator(API_KEYS_MAX_VERSION_SENSOR_NAME, API_KEYS_MAX_VERSION_SENSOR_NAME));
    }
}

