/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ClientInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInformationSensors {
    private static final String CONNECTION_INFO_NAME = "connection-info";
    private static final String UNIQUE_CONNECTION_INFO_METRICS_NAME = "unique-connection-info-metrics";
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionInformationSensors.class);
    private final Metrics metrics;
    private final int maxConnectionInfoMetricsPerTenant;
    private final String connectionInfoSensorName;
    private final MetricName connectionInfoMetricName;
    private final TenantMetrics.TenantLevelMetricsContext uniqueConnectionInfoMetricsContext;
    private final String uniqueConnectionInfoMetricsSensorName;
    private Sensor connectionInfoSensor;

    public ConnectionInformationSensors(Metrics metrics, MultiTenantPrincipal principal, ClientInformation clientInformation, String clientId, int maxConnectionInfoMetricsPerTenant) {
        this.metrics = metrics;
        this.maxConnectionInfoMetricsPerTenant = maxConnectionInfoMetricsPerTenant;
        TenantMetrics.TenantConnectionInformationMetricsContext connectionInformationContext = new TenantMetrics.TenantConnectionInformationMetricsContext(principal, clientInformation, clientId);
        this.connectionInfoSensorName = CONNECTION_INFO_NAME + connectionInformationContext.sensorSuffix();
        HashMap<String, String> combinedTags = new HashMap<String, String>(metrics.config().tags());
        combinedTags.putAll(connectionInformationContext.metricTags());
        this.connectionInfoMetricName = metrics.metricName("connection-info-rate", connectionInformationContext.metricsGroup(), combinedTags);
        this.uniqueConnectionInfoMetricsContext = new TenantMetrics.TenantLevelMetricsContext(principal);
        this.uniqueConnectionInfoMetricsSensorName = UNIQUE_CONNECTION_INFO_METRICS_NAME + this.uniqueConnectionInfoMetricsContext.sensorSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor recordAuthenticatedConnection() {
        LOCK.readLock().lock();
        try {
            this.connectionInfoSensor = this.metrics.getSensor(this.connectionInfoSensorName);
            if (this.connectionInfoSensor != null) {
                this.connectionInfoSensor.record();
                Sensor sensor = this.connectionInfoSensor;
                return sensor;
            }
        }
        finally {
            LOCK.readLock().unlock();
        }
        LOCK.writeLock().lock();
        try {
            this.connectionInfoSensor = this.metrics.getSensor(this.connectionInfoSensorName);
            if (this.connectionInfoSensor != null) {
                this.connectionInfoSensor.record();
                Sensor sensor = this.connectionInfoSensor;
                return sensor;
            }
            Sensor uniqueConnectionInfoMetricsSensor = this.metrics.getSensor(this.uniqueConnectionInfoMetricsSensorName);
            if (uniqueConnectionInfoMetricsSensor == null) {
                uniqueConnectionInfoMetricsSensor = this.createUniqueConnectionInfoMetricsSensor();
            }
            try {
                uniqueConnectionInfoMetricsSensor.record();
            }
            catch (QuotaViolationException e) {
                LOG.debug("Connection info metric was not created due to quota violation. Current max connection info metrics per tenant: {}", (Object)this.maxConnectionInfoMetricsPerTenant);
                uniqueConnectionInfoMetricsSensor.record(-1.0);
                Sensor sensor = null;
                LOCK.writeLock().unlock();
                return sensor;
            }
            this.connectionInfoSensor = this.createConnectionInfoSensor();
            this.connectionInfoSensor.record();
            Sensor sensor = this.connectionInfoSensor;
            return sensor;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor recordAuthenticatedDisconnection() {
        int authenticatedConnections2;
        KafkaMetric connectionInfoMetric;
        if (this.connectionInfoSensor == null) {
            return null;
        }
        this.connectionInfoSensor.record(-1.0);
        LOCK.readLock().lock();
        try {
            connectionInfoMetric = this.metrics.metric(this.connectionInfoMetricName);
            if (connectionInfoMetric == null) {
                Sensor sensor = null;
                return sensor;
            }
            authenticatedConnections2 = (int)connectionInfoMetric.measurableValue();
            if (authenticatedConnections2 > 0) {
                Sensor sensor = this.connectionInfoSensor;
                return sensor;
            }
        }
        finally {
            LOCK.readLock().unlock();
        }
        LOCK.writeLock().lock();
        try {
            connectionInfoMetric = this.metrics.metric(this.connectionInfoMetricName);
            if (connectionInfoMetric == null) {
                Sensor authenticatedConnections2 = null;
                return authenticatedConnections2;
            }
            authenticatedConnections2 = (int)connectionInfoMetric.measurableValue();
            if (authenticatedConnections2 > 0) {
                Sensor sensor = this.connectionInfoSensor;
                return sensor;
            }
            Sensor uniqueConnectionInfoMetricsSensor = this.metrics.getSensor(this.uniqueConnectionInfoMetricsSensorName);
            if (uniqueConnectionInfoMetricsSensor == null) {
                uniqueConnectionInfoMetricsSensor = this.createUniqueConnectionInfoMetricsSensor();
            }
            uniqueConnectionInfoMetricsSensor.record(-1.0);
            this.metrics.removeSensor(this.connectionInfoSensorName);
            Sensor sensor = null;
            return sensor;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    private Sensor createConnectionInfoSensor() {
        return this.createSensor(this.connectionInfoSensorName, this.connectionInfoMetricName, null);
    }

    private Sensor createUniqueConnectionInfoMetricsSensor() {
        LinkedHashMap<String, String> combinedTags = new LinkedHashMap<String, String>(this.metrics.config().tags());
        combinedTags.putAll(this.uniqueConnectionInfoMetricsContext.metricTags());
        combinedTags.put("io-confluent-jmx-ignore", "");
        MetricConfig metricConfig = new MetricConfig().tags(combinedTags).quota(Quota.upperBound((double)this.maxConnectionInfoMetricsPerTenant));
        MetricName metricName = this.metrics.metricName(UNIQUE_CONNECTION_INFO_METRICS_NAME, this.uniqueConnectionInfoMetricsContext.metricsGroup(), combinedTags);
        return this.createSensor(this.uniqueConnectionInfoMetricsSensorName, metricName, metricConfig);
    }

    private Sensor createSensor(String name, MetricName metricName, MetricConfig metricConfig) {
        Sensor sensor = this.metrics.sensor(name, metricConfig, new Sensor[0]);
        sensor.add(metricName, (MeasurableStat)new CumulativeSum());
        return sensor;
    }
}

