/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorCreator;

public class FailedAuthSensors {
    protected final Sensor failedAuthRate;

    public FailedAuthSensors(Sensor failedAuthRate) {
        this.failedAuthRate = failedAuthRate;
    }

    public void recordFailedAuthentication() {
        this.failedAuthRate.record();
    }

    protected static class FailedAuthSensorCreator
    extends AbstractSensorCreator {
        static final long FAILED_AUTH_EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);

        FailedAuthSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        Sensor createSensor(Metrics metrics, String sensorName, TenantMetrics.IpMetricsContext context) {
            Sensor sensor = super.createSensor(metrics, sensorName, FAILED_AUTH_EXPIRY_SECONDS);
            Map<String, String> metricTags = context.metricTags();
            sensor.add((CompoundStat)this.createMeter(metrics, context.metricsGroup(), metricTags, this.name, this.descriptiveName));
            return sensor;
        }
    }
}

