/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.AbstractPartitionSensorCreator;
import io.confluent.kafka.multitenant.metrics.PartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.server.metrics.utils.MetricUtils;

public class PartitionSensors {
    final ThroughputSensors in;
    final ThroughputSensors out;

    public PartitionSensors(TenantMetrics.MetricsRequestContext context, Metrics metrics, PartitionSensorBuilder sensorBuilder) {
        this.in = new ThroughputSensors(context, metrics, "partition-bytes-in", "partition-records-in", sensorBuilder);
        this.out = new ThroughputSensors(context, metrics, "partition-bytes-out", "partition-records-out", sensorBuilder);
    }

    public void recordStatsIn(TopicPartition tp, long bytes, long numRecords, long timeMs) {
        this.in.record(tp, bytes, numRecords, timeMs);
    }

    public void recordStatsOut(TopicPartition tp, long bytes, long numRecords, long timeMs) {
        this.out.record(tp, bytes, numRecords, timeMs);
    }

    static class ThroughputSensors {
        private final String bytesMetricName;
        private final String recordsMetricName;
        private final String tenant;
        private final String clientId;
        private final Metrics metrics;
        private final PartitionSensorBuilder partitionSensorBuilder;
        private final Map<TopicPartition, PartitionDetailSensors> partitionSensors;

        ThroughputSensors(TenantMetrics.MetricsRequestContext context, Metrics metrics, String bytesMetricName, String recordsMetricName, PartitionSensorBuilder partitionSensorBuilder) {
            this.bytesMetricName = bytesMetricName;
            this.recordsMetricName = recordsMetricName;
            this.tenant = context.principal().tenantMetadata().tenantName;
            this.clientId = context.clientId();
            this.metrics = metrics;
            this.partitionSensorBuilder = partitionSensorBuilder;
            this.partitionSensors = new ConcurrentHashMap<TopicPartition, PartitionDetailSensors>();
        }

        void record(TopicPartition tp, long bytes, long numRecords, long currentTimeMs) {
            PartitionDetailSensors partitionSensors = this.partitionDetailSensors(tp, this.metrics);
            partitionSensors.bytesSensor.record((double)bytes, currentTimeMs);
            partitionSensors.recordsSensor.record((double)numRecords, currentTimeMs);
            partitionSensors.rateSensor.record((double)bytes, currentTimeMs);
        }

        PartitionDetailSensors partitionDetailSensors(TopicPartition tp, Metrics metrics) {
            PartitionDetailSensors partitionSensor = this.partitionSensors.get(tp);
            if (partitionSensor != null && !partitionSensor.anyExpired(metrics)) {
                return partitionSensor;
            }
            PartitionSumSensorCreator bytesSensorCreator = new PartitionSumSensorCreator(this.bytesMetricName, this.bytesMetricName, this.tenant, this.clientId, tp);
            PartitionSumSensorCreator recordsSensorCreator = new PartitionSumSensorCreator(this.recordsMetricName, this.recordsMetricName, this.tenant, this.clientId, tp);
            PartitionRateSensorCreator rateSensorCreator = new PartitionRateSensorCreator(this.bytesMetricName, this.bytesMetricName, this.tenant, tp);
            String bytesSensorName = bytesSensorCreator.sensorName(this.bytesMetricName);
            String recordsSensorName = recordsSensorCreator.sensorName(this.recordsMetricName);
            String rateSensorName = rateSensorCreator.sensorName(this.bytesMetricName);
            HashMap<String, AbstractPartitionSensorCreator> sensorCreators = new HashMap<String, AbstractPartitionSensorCreator>(3);
            sensorCreators.put(bytesSensorName, bytesSensorCreator);
            sensorCreators.put(recordsSensorName, recordsSensorCreator);
            sensorCreators.put(rateSensorName, rateSensorCreator);
            HashMap<String, String> sensorsToFind = new HashMap<String, String>(3);
            sensorsToFind.put(bytesSensorName, bytesSensorName);
            sensorsToFind.put(recordsSensorName, recordsSensorName);
            sensorsToFind.put(rateSensorName, rateSensorName);
            Map s = this.partitionSensorBuilder.getOrCreateSensors(sensorsToFind, sensorCreators);
            PartitionDetailSensors sensors = new PartitionDetailSensors((Sensor)s.get(bytesSensorName), (Sensor)s.get(recordsSensorName), (Sensor)s.get(rateSensorName));
            this.partitionSensors.put(tp, sensors);
            return sensors;
        }
    }

    private static class PartitionRateSensorCreator
    extends AbstractPartitionSensorCreator {
        PartitionRateSensorCreator(String name, String descriptiveName, String tenant, TopicPartition tp) {
            super(name, descriptiveName, tenant, tp);
        }

        @Override
        protected void registerMetrics(Metrics metrics, Sensor sensor) {
            sensor.add(MetricUtils.rateMetricName((Metrics)metrics, (String)"tenant-metrics", this.metricTags(), (String)this.name, (String)this.name), (MeasurableStat)new Rate());
        }
    }

    static class PartitionSumSensorCreator
    extends AbstractPartitionSensorCreator {
        private final String clientId;

        PartitionSumSensorCreator(String name, String descriptiveName, String tenant, String clientId, TopicPartition tp) {
            super(name, descriptiveName, tenant, tp);
            this.clientId = clientId;
        }

        @Override
        protected Map<String, String> metricTags() {
            Map<String, String> tags = super.metricTags();
            tags.put("client-id", this.clientId);
            return tags;
        }

        @Override
        protected String sensorName(String baseName) {
            return String.format("%s:%s-%s:%s-%s:%s-%s,%s-%s", baseName, "tenant", this.tenant, "client-id", this.clientId, "topic", this.tp.topic(), "partition", this.tp.partition());
        }

        @Override
        protected void registerMetrics(Metrics metrics, Sensor sensor) {
            sensor.add(MetricUtils.totalMetricName((Metrics)metrics, (String)"tenant-metrics", this.metricTags(), (String)this.name, (String)this.name), (MeasurableStat)new CumulativeSum());
        }
    }

    static class PartitionDetailSensors {
        final Sensor bytesSensor;
        final Sensor recordsSensor;
        final Sensor rateSensor;

        public PartitionDetailSensors(Sensor bytesSensor, Sensor recordsSensor, Sensor rateSensor) {
            this.bytesSensor = bytesSensor;
            this.recordsSensor = recordsSensor;
            this.rateSensor = rateSensor;
        }

        boolean anyExpired(Metrics metrics) {
            return TenantMetrics.isExpired(metrics, this.bytesSensor) || TenantMetrics.isExpired(metrics, this.recordsSensor) || TenantMetrics.isExpired(metrics, this.rateSensor);
        }
    }
}

