/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.server.plugins.auth.token.TokenBearerValidatorCallbackHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallbackHandler;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeBearerValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CompositeBearerValidatorCallbackHandler.class);
    private final TokenBearerValidatorCallbackHandler mdsTokenValidator = new TokenBearerValidatorCallbackHandler();
    private final OAuthBearerValidatorCallbackHandler idpTokenValidator = new OAuthBearerValidatorCallbackHandler();
    private static final String DEFAULT_ISSUER = "Confluent";
    private final JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setDisableRequireSignature().setSkipAllValidators().build();

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.mdsTokenValidator.configure(configs, saslMechanism, jaasConfigEntries);
        this.idpTokenValidator.configure(configs, saslMechanism, jaasConfigEntries);
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                String tokenValue = ((OAuthBearerValidatorCallback)callback).tokenValue();
                try {
                    JwtClaims jwtClaims = this.jwtConsumer.processToClaims(tokenValue);
                    String issuer = jwtClaims.getIssuer();
                    if (Objects.equals(issuer, DEFAULT_ISSUER)) {
                        log.debug("Issuer is Confluent, using mds token validator");
                        this.mdsTokenValidator.handle(new Callback[]{callback});
                        continue;
                    }
                    log.debug("using IDP token validator");
                    this.idpTokenValidator.handle(new Callback[]{callback});
                }
                catch (Exception e) {
                    log.debug("Failed to verify token. ", (Throwable)e);
                    ((OAuthBearerValidatorCallback)callback).error("invalid_token", null, null);
                }
                continue;
            }
            if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                this.idpTokenValidator.handle(new Callback[]{callback});
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
        this.mdsTokenValidator.close();
        this.idpTokenValidator.close();
    }
}

