/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.operationgroupdefinitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class OperationGroupDefinition {
    private final String name;
    private final Map<ResourceType, Collection<Operation>> allowedOperations;

    @JsonCreator
    public OperationGroupDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="allowedOperations") Collection<AccessPolicy.ResourceOperations> allowedOperations) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Operation Group Definition name must be non-empty");
        }
        for (AccessPolicy.ResourceOperations ro : allowedOperations) {
            if ("All".equals(ro.resourceType)) {
                throw new IllegalArgumentException("Operation Group Definition cannot use 'All' as a resource type");
            }
            for (String operation : ro.operations) {
                if (!"All".equals(operation)) continue;
                throw new IllegalArgumentException("Operation Group Definition cannot use 'All' as an operation in resource type: " + ro.resourceType);
            }
        }
        this.name = name;
        this.allowedOperations = allowedOperations.stream().collect(Collectors.toMap(op -> ResourceType.resourceType(op.resourceType), op -> op.operations.stream().map(Operation::new).collect(Collectors.toList())));
    }

    public static OperationGroupDefinition merge(OperationGroupDefinition opgDef1, OperationGroupDefinition opgDef2) {
        if (!Objects.equals(opgDef1.name, opgDef2.name)) {
            throw new IllegalArgumentException("OPGMapping name does not match");
        }
        Collection<AccessPolicy.ResourceOperations> allowedOperations = AccessPolicy.mergeOperations(opgDef1.allowedOperations, opgDef2.allowedOperations);
        return new OperationGroupDefinition(opgDef1.name(), allowedOperations);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Collection<AccessPolicy.ResourceOperations> allowedOperations() {
        return this.allowedOperations.entrySet().stream().map(e -> new AccessPolicy.ResourceOperations(((ResourceType)e.getKey()).name(), ((Collection)e.getValue()).stream().map(Operation::name).collect(Collectors.toSet()))).collect(Collectors.toSet());
    }

    public Collection<Operation> allowedOperations(ResourceType resourceType) {
        Collection<Operation> ops = this.allowedOperations.get(resourceType);
        return ops == null ? Collections.emptySet() : ops;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperationGroupDefinition)) {
            return false;
        }
        OperationGroupDefinition that = (OperationGroupDefinition)o;
        return this.name.equals(that.name) && this.allowedOperations.equals(that.allowedOperations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.allowedOperations);
    }

    public String toString() {
        return "OperationGroupDefintion{name='" + this.name + '\'' + ", allowedOperations='" + this.allowedOperations + '\'' + '}';
    }
}

