/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common.network;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.cloud.protobuf.traffic.networkcontext.v1.NetworkContext;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.network.DefaultProxyTlvParser;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvParser;
import org.apache.kafka.common.network.ProxyTlvType;
import org.slf4j.Logger;

public class CloudProxyTlvParser
implements ProxyTlvParser {
    public static final int PP2_TYPE_CFLTV2 = 227;
    public static final int PP2_SUBTYPE_CFLTV2_NETWORK_CONTEXT = 1;
    public static final ProxyTlvType NETWORK_CONTEXT_TLV_TYPE = new ProxyTlvType(227, Optional.of(1));
    DefaultProxyTlvParser defaultParser = new DefaultProxyTlvParser();

    public void configure(Map<String, ?> configs) {
        this.defaultParser.configure(configs);
    }

    public Optional<ProxyTlv> parse(Logger log, int tlvType, byte[] bytes) {
        if (tlvType != 227) {
            return this.defaultParser.parse(log, tlvType, bytes);
        }
        return this.createReservedTlv2(log, bytes);
    }

    private Optional<ProxyTlv> createReservedTlv2(Logger log, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            log.error("Received empty TLV bytes for PP2_TYPE_CFLTV2");
            return Optional.empty();
        }
        int tlvSubtype = bytes[0] & 0xFF;
        if (tlvSubtype == 1) {
            return this.parseNetworkContext(log, bytes);
        }
        log.error("There is no parser for subtype:{}", (Object)tlvSubtype);
        return Optional.empty();
    }

    private Optional<ProxyTlv> parseNetworkContext(Logger log, byte[] bytes) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes, 1, bytes.length - 1);
            NetworkContext networkContext = NetworkContext.parseFrom(buffer);
            return Optional.of(new ProxyTlv(NETWORK_CONTEXT_TLV_TYPE, bytes, (Object)networkContext));
        }
        catch (InvalidProtocolBufferException ex) {
            log.error("Error parsing NetworkContext from TLV bytes", (Throwable)ex);
            return Optional.empty();
        }
    }
}

