/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import io.confluent.kafkarest.auth.AuthorizationHeader;
import io.confluent.kafkarest.auth.CloudPrincipal;
import io.confluent.kafkarest.auth.CloudSecurityContext;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public final class CloudExtensionsAuthFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CloudExtensionsAuthFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            String clusterId = (String)requestContext.getUriInfo().getPathParameters(true).getFirst((Object)"clusterId");
            AuthorizationHeader authorizationHeader = AuthorizationHeader.parse((String)requestContext.getHeaders().getFirst((Object)"Authorization"));
            CloudPrincipal principal = CloudPrincipal.create(clusterId, authorizationHeader);
            boolean isSecure = requestContext.getUriInfo().getRequestUri().toString().startsWith("https");
            requestContext.setSecurityContext((SecurityContext)new CloudSecurityContext(principal, isSecure));
        }
        catch (Exception e) {
            log.debug("Failed to extract credentials from request.");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }
}

