/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.backends.kafka;

import io.confluent.kafkarest.KafkaRestContext;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.Producer;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;

public final class CloudKafkaModule
extends AbstractBinder {
    public static final String KAFKA_REST_CONTEXT_PROPERTY_NAME = "io.confluent.kafkarest.backends.kafka.CloudKafkaModule.KafkaRestContext";

    protected void configure() {
        this.bindFactory(KafkaRestContextFactory.class).to(KafkaRestContext.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(RequestScoped.class).ranked(1);
    }

    private static final class ProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private ProducerFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return ((KafkaRestContext)this.context.get()).getProducer();
        }

        public void dispose(Producer<byte[], byte[]> producer) {
            producer.close();
        }
    }

    private static final class ConfluentAdminFactory
    implements Factory<ConfluentAdmin> {
        private final Provider<Admin> admin;

        @Inject
        public ConfluentAdminFactory(Provider<Admin> admin) {
            this.admin = Objects.requireNonNull(admin);
        }

        public ConfluentAdmin provide() {
            return (ConfluentAdmin)this.admin.get();
        }

        public void dispose(ConfluentAdmin instance) {
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private AdminFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return ((KafkaRestContext)this.context.get()).getAdmin();
        }

        public void dispose(Admin admin) {
            admin.close();
        }
    }

    private static final class KafkaRestContextFactory
    implements Factory<KafkaRestContext> {
        private final Provider<ContainerRequestContext> requestContext;

        @Inject
        private KafkaRestContextFactory(@Context Provider<ContainerRequestContext> requestContext) {
            this.requestContext = Objects.requireNonNull(requestContext);
        }

        public KafkaRestContext provide() {
            return (KafkaRestContext)Objects.requireNonNull(((ContainerRequestContext)this.requestContext.get()).getProperty(CloudKafkaModule.KAFKA_REST_CONTEXT_PROPERTY_NAME), "KafkaRestContext cannot be null.");
        }

        public void dispose(KafkaRestContext context) {
            context.shutdown();
        }
    }
}

