/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.BalancerManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ErrorUtils;
import io.confluent.kafkarest.entities.Balancer;
import io.confluent.kafkarest.entities.BalancerAnyUnevenLoadStatus;
import io.confluent.kafkarest.entities.Cluster;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.common.KafkaFuture;

final class BalancerManagerImpl
implements BalancerManager {
    private final ClusterManager clusterManager;
    private final ConfluentAdmin confluentAdminClient;

    @Inject
    BalancerManagerImpl(ClusterManager clusterManager, ConfluentAdmin confluentAdminClient) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.confluentAdminClient = Objects.requireNonNull(confluentAdminClient);
    }

    @Override
    public CompletableFuture<Optional<Balancer>> getBalancer(String clusterId) {
        CompletionStage result = ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBalancerStatus().description()))).thenApply(description -> Optional.of(BalancerManagerImpl.toBalancer(clusterId, description)));
        return ErrorUtils.catchTimeoutExceptionCause(result);
    }

    @Override
    public CompletableFuture<Optional<BalancerAnyUnevenLoadStatus>> getAnyUnevenLoad(String clusterId) {
        CompletionStage result = ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeEvenClusterLoadStatus().description()))).thenApply(description -> Optional.of(BalancerManagerImpl.toAnyUnevenLoad(clusterId, description)));
        return ErrorUtils.catchTimeoutExceptionCause(result);
    }

    private static Balancer toBalancer(String clusterId, BalancerStatusDescription description) {
        Balancer.Builder builder = Balancer.builder().setClusterId(clusterId).setStatus(description.balancerStatus());
        if (description.balancerOperationError().isPresent()) {
            builder = builder.setErrorCode(((BalancerOperationError)description.balancerOperationError().get()).errorCode()).setErrorMessage(((BalancerOperationError)description.balancerOperationError().get()).errorMessage());
        }
        return builder.build();
    }

    private static BalancerAnyUnevenLoadStatus toAnyUnevenLoad(String clusterId, EvenClusterLoadStatusDescription description) {
        BalancerAnyUnevenLoadStatus.Builder builder = BalancerAnyUnevenLoadStatus.builder().setClusterId(clusterId).setStatus(description.currentEvenClusterLoadStatus()).setPreviousStatus(description.previousEvenClusterLoadStatus()).setStatusUpdatedAt(description.currentStatusLastUpdatetimeMs() != 0L ? Instant.ofEpochMilli(description.currentStatusLastUpdatetimeMs()) : null).setPreviousStatusUpdatedAt(description.previousStatusLastUpdatetimeMs() != 0L ? Instant.ofEpochMilli(description.previousStatusLastUpdatetimeMs()) : null);
        if (description.evenClusterLoadError().isPresent()) {
            builder = builder.setErrorCode(((BalancerOperationError)description.evenClusterLoadError().get()).errorCode()).setErrorMessage(((BalancerOperationError)description.evenClusterLoadError().get()).errorMessage());
        }
        return builder.build();
    }
}

