/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.BrokerReplicaExclusionManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ErrorUtils;
import io.confluent.kafkarest.entities.AlterBrokerReplicaExclusion;
import io.confluent.kafkarest.entities.BrokerReplicaExclusion;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.v3.BrokerReplicaExclusionBatchRequest;
import io.confluent.kafkarest.entities.v3.BrokerReplicaExclusionRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.BrokerReplicaExclusionNotFoundException;

final class BrokerReplicaExclusionManagerImpl
implements BrokerReplicaExclusionManager {
    private final ClusterManager clusterManager;
    private final ConfluentAdmin confluentAdminClient;

    @Inject
    BrokerReplicaExclusionManagerImpl(ClusterManager clusterManager, ConfluentAdmin confluentAdminClient) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.confluentAdminClient = Objects.requireNonNull(confluentAdminClient);
    }

    @Override
    public CompletableFuture<List<BrokerReplicaExclusion>> listBrokerReplicaExclusions(String clusterId) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerReplicaExclusions().descriptions()))).thenApply(descriptions -> descriptions.stream().map(description -> BrokerReplicaExclusionManagerImpl.toBrokerReplicaExclusion(clusterId, description)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Optional<BrokerReplicaExclusion>> getBrokerReplicaExclusions(String clusterId, int brokerId) {
        return this.listBrokerReplicaExclusions(clusterId).thenApply(brokerReplicaExclusions -> Entities.findEntityByKey((Collection)brokerReplicaExclusions, BrokerReplicaExclusion::getBrokerId, (Object)brokerId));
    }

    @Override
    public CompletableFuture<List<AlterBrokerReplicaExclusion>> createBrokerReplicaExclusions(String clusterId, BrokerReplicaExclusionBatchRequest createBrokerReplicaExclusionsBatchRequest) {
        return ErrorUtils.catchUnrepresentableBrokerIdException(this.alterBrokerReplicaExclusions(clusterId, createBrokerReplicaExclusionsBatchRequest, ExclusionOp.OpType.SET));
    }

    @Override
    public CompletableFuture<List<AlterBrokerReplicaExclusion>> deleteBrokerReplicaExclusions(String clusterId, BrokerReplicaExclusionBatchRequest deleteBrokerReplicaExclusionsBatchRequest) {
        return ErrorUtils.catchUnrepresentableBrokerIdException(this.alterBrokerReplicaExclusions(clusterId, deleteBrokerReplicaExclusionsBatchRequest, ExclusionOp.OpType.DELETE));
    }

    private CompletableFuture<List<AlterBrokerReplicaExclusion>> alterBrokerReplicaExclusions(String clusterId, BrokerReplicaExclusionBatchRequest brokerReplicaExclusionsBatchRequest, ExclusionOp.OpType opType) {
        Map<Integer, ExclusionOp> exclusionOpMap = brokerReplicaExclusionsBatchRequest.getValue().getData().stream().collect(Collectors.toMap(BrokerReplicaExclusionRequest::getBrokerId, entry -> new ExclusionOp(opType, entry.getReason())));
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.alterBrokerReplicaExclusions(exclusionOpMap).result()))).thenApply(result -> BrokerReplicaExclusionManagerImpl.toAlterBrokerReplicaExclusion(clusterId, result));
    }

    private static BrokerReplicaExclusion toBrokerReplicaExclusion(String clusterId, DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription description) {
        return BrokerReplicaExclusion.builder().setClusterId(clusterId).setBrokerId(description.brokerId()).setReason(description.reason()).build();
    }

    private static List<AlterBrokerReplicaExclusion> toAlterBrokerReplicaExclusion(String clusterId, AlterBrokerReplicaExclusionsResult.ExclusionsResult exclusionsResult) {
        Map exclusionsByBroker = exclusionsResult.exclusionResultByBroker();
        return exclusionsByBroker.entrySet().stream().map(entry -> {
            int brokerId = (Integer)entry.getKey();
            ExclusionOpResult exclusionOpResult = (ExclusionOpResult)entry.getValue();
            AlterBrokerReplicaExclusion.Builder alterBrokerReplicaExclusionBuilder = AlterBrokerReplicaExclusion.builder().setClusterId(clusterId).setBrokerId(brokerId).setExclusion(exclusionOpResult.opType()).setReason(exclusionOpResult.reason());
            if (exclusionOpResult.errorOpt().isPresent()) {
                if (((ExclusionOperationError)exclusionOpResult.errorOpt().get()).exception() instanceof BrokerReplicaExclusionNotFoundException) {
                    alterBrokerReplicaExclusionBuilder.setErrorCode((short)Response.Status.NOT_FOUND.getStatusCode()).setErrorMessage(((ExclusionOperationError)exclusionOpResult.errorOpt().get()).errorMessage());
                } else {
                    alterBrokerReplicaExclusionBuilder.setErrorCode(((ExclusionOperationError)exclusionOpResult.errorOpt().get()).errorCode()).setErrorMessage(((ExclusionOperationError)exclusionOpResult.errorOpt().get()).errorMessage());
                }
            }
            return alterBrokerReplicaExclusionBuilder.build();
        }).collect(Collectors.toList());
    }
}

