/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.BrokerTaskManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ExtensionsBrokerManagerImpl;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.BrokerSubTaskStatuses;
import io.confluent.kafkarest.entities.BrokerTask;
import io.confluent.kafkarest.entities.BrokerTaskType;
import io.confluent.kafkarest.entities.Cluster;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;

final class BrokerTaskManagerImpl
implements BrokerTaskManager {
    private final ClusterManager clusterManager;
    private final ConfluentAdmin confluentAdminClient;

    @Inject
    BrokerTaskManagerImpl(ClusterManager clusterManager, ConfluentAdmin confluentAdminClient) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.confluentAdminClient = Objects.requireNonNull(confluentAdminClient);
    }

    @Override
    public CompletableFuture<List<BrokerTask>> listBrokerTasks(String clusterId) {
        CompletionStage c = this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}));
        CompletionStage addBrokerTasks = ((CompletableFuture)c).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerAdditions().descriptions()).thenApply(descriptions -> descriptions.values().stream().map(description -> BrokerTaskManagerImpl.toBrokerTask(clusterId, description)).collect(Collectors.toList())));
        CompletionStage removeBrokerTasks = ((CompletableFuture)c).thenCompose(brokerTasks -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerRemovals().descriptions()).thenApply(descriptions -> descriptions.values().stream().map(description -> BrokerTaskManagerImpl.toBrokerTask(clusterId, description)).collect(Collectors.toList())));
        return ExtensionsBrokerManagerImpl.catchSbkOfflineException(CompletableFutures.allAsList(Arrays.asList(addBrokerTasks, removeBrokerTasks)).thenApply(brokerTaskListWrapper -> brokerTaskListWrapper.stream().flatMap(Collection::stream).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<List<BrokerTask>> listBrokerTasksByTaskType(String clusterId, BrokerTaskType taskType) {
        CompletionStage result = ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> {
            switch (taskType) {
                case ADD_BROKER: {
                    return KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerAdditions().descriptions()).thenApply(descriptions -> descriptions.values().stream().map(description -> BrokerTaskManagerImpl.toBrokerTask(clusterId, description)).collect(Collectors.toList()));
                }
                case REMOVE_BROKER: {
                    return KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerRemovals().descriptions()).thenApply(descriptions -> descriptions.values().stream().map(description -> BrokerTaskManagerImpl.toBrokerTask(clusterId, description)).collect(Collectors.toList()));
                }
            }
            throw new AssertionError((Object)String.format("Unknown task type found: %s", new Object[]{taskType}));
        });
        return ExtensionsBrokerManagerImpl.catchSbkOfflineException(result);
    }

    @Override
    public CompletableFuture<List<BrokerTask>> listBrokerTasksByBroker(String clusterId, int brokerId) {
        CompletionStage cluster = this.clusterManager.getCluster(clusterId).thenApply(c -> (Cluster)Entities.checkEntityExists((Optional)c, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}));
        CompletionStage addBrokerTask = ((CompletableFuture)cluster).thenCompose(c -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerAdditions().description(brokerId)).thenApply(descriptionOpt -> descriptionOpt.map(brokerAdditionDescription -> BrokerTaskManagerImpl.toBrokerTask(clusterId, brokerAdditionDescription))));
        CompletionStage removeBrokerTask = ((CompletableFuture)cluster).thenCompose(c -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerRemovals().description(brokerId)).thenApply(descriptionOpt -> descriptionOpt.map(brokerRemovalDescription -> BrokerTaskManagerImpl.toBrokerTask(clusterId, brokerRemovalDescription))));
        CompletionStage result = ((CompletableFuture)((CompletableFuture)CompletableFutures.allAsList(Arrays.asList(addBrokerTask, removeBrokerTask)).thenApply(brokerTaskListWrapper -> Stream.of(brokerTaskListWrapper).flatMap(Collection::stream).collect(Collectors.toList()))).thenApply(brokerTaskListWrapper -> brokerTaskListWrapper.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()))).thenCompose(arg_0 -> BrokerTaskManagerImpl.lambda$listBrokerTasksByBroker$26((CompletableFuture)cluster, brokerId, arg_0));
        return ExtensionsBrokerManagerImpl.catchSbkOfflineException(result);
    }

    @Override
    public CompletableFuture<Optional<BrokerTask>> getBrokerTask(String clusterId, int brokerId, BrokerTaskType taskType) {
        CompletionStage result = ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(broker -> {
            switch (taskType) {
                case ADD_BROKER: {
                    return KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerAdditions().description(brokerId)).thenApply(description -> description.map(brokerAdditionDescription -> BrokerTaskManagerImpl.toBrokerTask(clusterId, brokerAdditionDescription)));
                }
                case REMOVE_BROKER: {
                    return KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerRemovals().description(brokerId)).thenApply(description -> description.map(brokerRemovalDescription -> BrokerTaskManagerImpl.toBrokerTask(clusterId, brokerRemovalDescription)));
                }
            }
            throw new AssertionError((Object)String.format("Unknown task type found: %s", new Object[]{taskType}));
        });
        return ExtensionsBrokerManagerImpl.catchSbkOfflineException(result);
    }

    private static BrokerTask toBrokerTask(String clusterId, BrokerAdditionDescription description) {
        BrokerTask.Builder builder = BrokerTask.builder().setClusterId(clusterId).setBrokerId(description.brokerId()).setTaskType(BrokerTaskType.ADD_BROKER).setBrokerTaskStatus(BalancerOperationStatus.valueOf((String)description.generalOperationStatus().name())).setBrokerSubTaskStatuses(BrokerSubTaskStatuses.builder().setPartitionReassignmentStatus(description.partitionReassignmentsStatus()).build()).setCreatedAt(Instant.ofEpochMilli(description.createTimeMs())).setUpdatedAt(Instant.ofEpochMilli(description.lastUpdateTimeMs()));
        if (description.additionError().isPresent()) {
            builder = builder.setErrorCode(((BalancerOperationError)description.additionError().get()).errorCode()).setErrorMessage(((BalancerOperationError)description.additionError().get()).errorMessage());
        }
        return builder.build();
    }

    private static BrokerTask toBrokerTask(String clusterId, BrokerRemovalDescription description) {
        BrokerTask.Builder builder = BrokerTask.builder().setClusterId(clusterId).setBrokerId(description.brokerId()).setTaskType(BrokerTaskType.REMOVE_BROKER).setShutdownScheduled(description.isShutdownScheduled()).setBrokerTaskStatus(description.generalOperationStatus()).setBrokerSubTaskStatuses(BrokerSubTaskStatuses.builder().setBrokerReplicaExclusionStatus(description.brokerReplicaExclusionStatus()).setPartitionReassignmentStatus(description.reassignmentsStatus()).setBrokerShutdownStatus(description.shutdownStatus()).build()).setCreatedAt(Instant.ofEpochMilli(description.createTimeMs())).setUpdatedAt(Instant.ofEpochMilli(description.lastUpdateTimeMs()));
        if (description.removalError().isPresent()) {
            builder = builder.setErrorCode(((BrokerRemovalError)description.removalError().get()).errorCode()).setErrorMessage(((BrokerRemovalError)description.removalError().get()).errorMessage());
        }
        return builder.build();
    }

    private static /* synthetic */ CompletionStage lambda$listBrokerTasksByBroker$26(CompletableFuture cluster, int brokerId, List brokerTaskList) {
        if (brokerTaskList.isEmpty()) {
            return ((CompletableFuture)((CompletableFuture)cluster.thenApply(c -> Entities.findEntityByKey((Collection)c.getBrokers(), Broker::getBrokerId, (Object)brokerId))).thenApply(broker -> (Broker)Entities.checkEntityExists((Optional)broker, (String)"Broker %d cannot be found.", (Object[])new Object[]{brokerId}))).thenApply(broker -> brokerTaskList);
        }
        return CompletableFuture.completedFuture(brokerTaskList);
    }
}

