/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.RemoveBrokerTaskManager;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.RemoveBrokerTask;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;

final class RemoveBrokerTaskManagerImpl
implements RemoveBrokerTaskManager {
    private final ClusterManager clusterManager;
    private final ConfluentAdmin confluentAdminClient;

    @Inject
    RemoveBrokerTaskManagerImpl(ClusterManager clusterManager, ConfluentAdmin confluentAdminClient) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.confluentAdminClient = Objects.requireNonNull(confluentAdminClient);
    }

    @Override
    public CompletableFuture<List<RemoveBrokerTask>> listRemoveBrokerTasks(String clusterId) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.confluentAdminClient.describeBrokerRemovals().descriptions()))).thenApply(descriptions -> descriptions.values().stream().map(description -> RemoveBrokerTaskManagerImpl.toRemoveBrokerTask(clusterId, description)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Optional<RemoveBrokerTask>> getRemoveBrokerTask(String clusterId, int brokerId) {
        return this.listRemoveBrokerTasks(clusterId).thenApply(removeBrokerTasks -> Entities.findEntityByKey((Collection)removeBrokerTasks, RemoveBrokerTask::getBrokerId, (Object)brokerId));
    }

    private static RemoveBrokerTask toRemoveBrokerTask(String clusterId, BrokerRemovalDescription description) {
        if (description.removalError().isPresent()) {
            return RemoveBrokerTask.create(clusterId, description.brokerId(), description.isShutdownScheduled(), description.brokerReplicaExclusionStatus(), description.shutdownStatus(), description.reassignmentsStatus(), ((BrokerRemovalError)description.removalError().get()).errorCode(), ((BrokerRemovalError)description.removalError().get()).errorMessage());
        }
        return RemoveBrokerTask.create(clusterId, description.brokerId(), description.isShutdownScheduled(), description.brokerReplicaExclusionStatus(), description.shutdownStatus(), description.reassignmentsStatus());
    }
}

