/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.BrokerSubTaskStatuses;
import io.confluent.kafkarest.entities.BrokerTask;
import io.confluent.kafkarest.entities.BrokerTaskType;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.BalancerOperationStatus;

final class AutoValue_BrokerTask
extends BrokerTask {
    private final String clusterId;
    private final int brokerId;
    private final BrokerTaskType taskType;
    private final BalancerOperationStatus brokerTaskStatus;
    private final Optional<Boolean> shutdownScheduled;
    private final BrokerSubTaskStatuses brokerSubTaskStatuses;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_BrokerTask(String clusterId, int brokerId, BrokerTaskType taskType, BalancerOperationStatus brokerTaskStatus, Optional<Boolean> shutdownScheduled, BrokerSubTaskStatuses brokerSubTaskStatuses, Instant createdAt, Instant updatedAt, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.taskType = taskType;
        this.brokerTaskStatus = brokerTaskStatus;
        this.shutdownScheduled = shutdownScheduled;
        this.brokerSubTaskStatuses = brokerSubTaskStatuses;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    public BrokerTaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public BalancerOperationStatus getBrokerTaskStatus() {
        return this.brokerTaskStatus;
    }

    @Override
    public Optional<Boolean> getShutdownScheduled() {
        return this.shutdownScheduled;
    }

    @Override
    public BrokerSubTaskStatuses getBrokerSubTaskStatuses() {
        return this.brokerSubTaskStatuses;
    }

    @Override
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "BrokerTask{clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", taskType=" + (Object)((Object)this.taskType) + ", brokerTaskStatus=" + this.brokerTaskStatus + ", shutdownScheduled=" + this.shutdownScheduled + ", brokerSubTaskStatuses=" + this.brokerSubTaskStatuses + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BrokerTask) {
            BrokerTask that = (BrokerTask)o;
            return this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.taskType.equals((Object)that.getTaskType()) && this.brokerTaskStatus.equals((Object)that.getBrokerTaskStatus()) && this.shutdownScheduled.equals(that.getShutdownScheduled()) && this.brokerSubTaskStatuses.equals(that.getBrokerSubTaskStatuses()) && this.createdAt.equals(that.getCreatedAt()) && this.updatedAt.equals(that.getUpdatedAt()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.taskType.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerTaskStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.shutdownScheduled.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerSubTaskStatuses.hashCode();
        h$ *= 1000003;
        h$ ^= this.createdAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.updatedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends BrokerTask.Builder {
        private String clusterId;
        private Integer brokerId;
        private BrokerTaskType taskType;
        private BalancerOperationStatus brokerTaskStatus;
        private Optional<Boolean> shutdownScheduled = Optional.empty();
        private BrokerSubTaskStatuses brokerSubTaskStatuses;
        private Instant createdAt;
        private Instant updatedAt;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        @Override
        public BrokerTask.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BrokerTask.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public BrokerTask.Builder setTaskType(BrokerTaskType taskType) {
            if (taskType == null) {
                throw new NullPointerException("Null taskType");
            }
            this.taskType = taskType;
            return this;
        }

        @Override
        public BrokerTask.Builder setBrokerTaskStatus(BalancerOperationStatus brokerTaskStatus) {
            if (brokerTaskStatus == null) {
                throw new NullPointerException("Null brokerTaskStatus");
            }
            this.brokerTaskStatus = brokerTaskStatus;
            return this;
        }

        @Override
        public BrokerTask.Builder setShutdownScheduled(@Nullable Boolean shutdownScheduled) {
            this.shutdownScheduled = Optional.ofNullable(shutdownScheduled);
            return this;
        }

        @Override
        public BrokerTask.Builder setBrokerSubTaskStatuses(BrokerSubTaskStatuses brokerSubTaskStatuses) {
            if (brokerSubTaskStatuses == null) {
                throw new NullPointerException("Null brokerSubTaskStatuses");
            }
            this.brokerSubTaskStatuses = brokerSubTaskStatuses;
            return this;
        }

        @Override
        public BrokerTask.Builder setCreatedAt(Instant createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public BrokerTask.Builder setUpdatedAt(Instant updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("Null updatedAt");
            }
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public BrokerTask.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BrokerTask.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BrokerTask build() {
            String missing = "";
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = missing + " brokerId";
            }
            if (this.taskType == null) {
                missing = missing + " taskType";
            }
            if (this.brokerTaskStatus == null) {
                missing = missing + " brokerTaskStatus";
            }
            if (this.brokerSubTaskStatuses == null) {
                missing = missing + " brokerSubTaskStatuses";
            }
            if (this.createdAt == null) {
                missing = missing + " createdAt";
            }
            if (this.updatedAt == null) {
                missing = missing + " updatedAt";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BrokerTask(this.clusterId, this.brokerId, this.taskType, this.brokerTaskStatus, this.shutdownScheduled, this.brokerSubTaskStatuses, this.createdAt, this.updatedAt, this.errorCode, this.errorMessage);
        }
    }
}

