/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.ConfigSynonym;
import io.confluent.kafkarest.entities.LinkConfig;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_LinkConfig
extends LinkConfig {
    private final String clusterId;
    private final String name;
    private final String value;
    private final boolean default0;
    private final boolean readOnly;
    private final boolean sensitive;
    private final ConfigSource source;
    private final ImmutableList<ConfigSynonym> synonyms;
    private final String linkName;

    private AutoValue_LinkConfig(String clusterId, String name, @Nullable String value, boolean default0, boolean readOnly, boolean sensitive, ConfigSource source, ImmutableList<ConfigSynonym> synonyms, String linkName) {
        this.clusterId = clusterId;
        this.name = name;
        this.value = value;
        this.default0 = default0;
        this.readOnly = readOnly;
        this.sensitive = sensitive;
        this.source = source;
        this.synonyms = synonyms;
        this.linkName = linkName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public boolean isDefault() {
        return this.default0;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public ConfigSource getSource() {
        return this.source;
    }

    public ImmutableList<ConfigSynonym> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public String getLinkName() {
        return this.linkName;
    }

    public String toString() {
        return "LinkConfig{clusterId=" + this.clusterId + ", name=" + this.name + ", value=" + this.value + ", default=" + this.default0 + ", readOnly=" + this.readOnly + ", sensitive=" + this.sensitive + ", source=" + this.source + ", synonyms=" + this.synonyms + ", linkName=" + this.linkName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinkConfig) {
            LinkConfig that = (LinkConfig)((Object)o);
            return this.clusterId.equals(that.getClusterId()) && this.name.equals(that.getName()) && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue())) && this.default0 == that.isDefault() && this.readOnly == that.isReadOnly() && this.sensitive == that.isSensitive() && this.source.equals((Object)that.getSource()) && this.synonyms.equals((Object)that.getSynonyms()) && this.linkName.equals(that.getLinkName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.value == null ? 0 : this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.default0 ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.readOnly ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sensitive ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.source.hashCode();
        h$ *= 1000003;
        h$ ^= this.synonyms.hashCode();
        h$ *= 1000003;
        return h$ ^= this.linkName.hashCode();
    }

    static final class Builder
    extends LinkConfig.Builder {
        private String clusterId;
        private String name;
        private String value;
        private Boolean default0;
        private Boolean readOnly;
        private Boolean sensitive;
        private ConfigSource source;
        private ImmutableList<ConfigSynonym> synonyms;
        private String linkName;

        Builder() {
        }

        public LinkConfig.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        public LinkConfig.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        public LinkConfig.Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public LinkConfig.Builder setDefault(boolean default0) {
            this.default0 = default0;
            return this;
        }

        public LinkConfig.Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public LinkConfig.Builder setSensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public LinkConfig.Builder setSource(ConfigSource source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        public LinkConfig.Builder setSynonyms(List<ConfigSynonym> synonyms) {
            this.synonyms = ImmutableList.copyOf(synonyms);
            return this;
        }

        @Override
        public LinkConfig.Builder setLinkName(String linkName) {
            if (linkName == null) {
                throw new NullPointerException("Null linkName");
            }
            this.linkName = linkName;
            return this;
        }

        public LinkConfig build() {
            String missing = "";
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.default0 == null) {
                missing = missing + " default";
            }
            if (this.readOnly == null) {
                missing = missing + " readOnly";
            }
            if (this.sensitive == null) {
                missing = missing + " sensitive";
            }
            if (this.source == null) {
                missing = missing + " source";
            }
            if (this.synonyms == null) {
                missing = missing + " synonyms";
            }
            if (this.linkName == null) {
                missing = missing + " linkName";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_LinkConfig(this.clusterId, this.name, this.value, this.default0, this.readOnly, this.sensitive, this.source, this.synonyms, this.linkName);
        }
    }
}

