/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum HealthCheckStatus {
    OK(0),
    WARNING(1),
    CRITICAL(2),
    UNKNOWN(3);

    private static final String STATUS_PROP = "status";
    private static final String STATUS_CODE_PROP = "status_code";
    private final int statusCode;

    private HealthCheckStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.name();
    }

    @JsonProperty(value="status_code")
    public int getStatusCode() {
        return this.statusCode;
    }

    @JsonCreator
    public static HealthCheckStatus fromJson(JsonNode node) {
        if (!node.has(STATUS_PROP)) {
            throw new IllegalArgumentException(String.format("Health check status should contain '%s' field", STATUS_PROP));
        }
        if (!node.has(STATUS_CODE_PROP)) {
            throw new IllegalArgumentException(String.format("Health check status should contain '%s' field", STATUS_CODE_PROP));
        }
        String status = node.get(STATUS_PROP).asText();
        int statusCode = node.get(STATUS_CODE_PROP).asInt();
        HealthCheckStatus healthCheckStatus = HealthCheckStatus.valueOf(status);
        if (healthCheckStatus.statusCode != statusCode) {
            throw new IllegalArgumentException(String.format("Health check status %s should have status code %d instead of %d", new Object[]{healthCheckStatus, healthCheckStatus.statusCode, statusCode}));
        }
        return healthCheckStatus;
    }
}

