/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.BalancerData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.BalancerStatus;

final class AutoValue_BalancerData
extends BalancerData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final BalancerStatus status;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;
    private final Resource.Relationship anyUnevenLoad;
    private final Resource.Relationship brokerTasks;

    private AutoValue_BalancerData(String kind, Resource.Metadata metadata, String clusterId, BalancerStatus status, Optional<Short> errorCode, Optional<String> errorMessage, Resource.Relationship anyUnevenLoad, Resource.Relationship brokerTasks) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.status = status;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.anyUnevenLoad = anyUnevenLoad;
        this.brokerTasks = brokerTasks;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="status")
    public BalancerStatus getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="error_code")
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="any_uneven_load")
    public Resource.Relationship getAnyUnevenLoad() {
        return this.anyUnevenLoad;
    }

    @Override
    @JsonProperty(value="broker_tasks")
    public Resource.Relationship getBrokerTasks() {
        return this.brokerTasks;
    }

    public String toString() {
        return "BalancerData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", status=" + this.status + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", anyUnevenLoad=" + this.anyUnevenLoad + ", brokerTasks=" + this.brokerTasks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BalancerData) {
            BalancerData that = (BalancerData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.status.equals((Object)that.getStatus()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage()) && this.anyUnevenLoad.equals(that.getAnyUnevenLoad()) && this.brokerTasks.equals(that.getBrokerTasks());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.status.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage.hashCode();
        h$ *= 1000003;
        h$ ^= this.anyUnevenLoad.hashCode();
        h$ *= 1000003;
        return h$ ^= this.brokerTasks.hashCode();
    }

    static final class Builder
    extends BalancerData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private BalancerStatus status;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Resource.Relationship anyUnevenLoad;
        private Resource.Relationship brokerTasks;

        Builder() {
        }

        public BalancerData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public BalancerData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public BalancerData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BalancerData.Builder setStatus(BalancerStatus status) {
            if (status == null) {
                throw new NullPointerException("Null status");
            }
            this.status = status;
            return this;
        }

        @Override
        public BalancerData.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BalancerData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BalancerData.Builder setAnyUnevenLoad(Resource.Relationship anyUnevenLoad) {
            if (anyUnevenLoad == null) {
                throw new NullPointerException("Null anyUnevenLoad");
            }
            this.anyUnevenLoad = anyUnevenLoad;
            return this;
        }

        @Override
        public BalancerData.Builder setBrokerTasks(Resource.Relationship brokerTasks) {
            if (brokerTasks == null) {
                throw new NullPointerException("Null brokerTasks");
            }
            this.brokerTasks = brokerTasks;
            return this;
        }

        @Override
        public BalancerData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.status == null) {
                missing = missing + " status";
            }
            if (this.anyUnevenLoad == null) {
                missing = missing + " anyUnevenLoad";
            }
            if (this.brokerTasks == null) {
                missing = missing + " brokerTasks";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BalancerData(this.kind, this.metadata, this.clusterId, this.status, this.errorCode, this.errorMessage, this.anyUnevenLoad, this.brokerTasks);
        }
    }
}

