/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.BrokerTask;
import io.confluent.kafkarest.entities.BrokerTaskType;
import io.confluent.kafkarest.entities.v3.AutoValue_BrokerTaskData;
import io.confluent.kafkarest.entities.v3.BrokerSubTaskStatusesData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.BalancerOperationStatus;

@AutoValue
public abstract class BrokerTaskData
extends Resource {
    BrokerTaskData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="task_type")
    public abstract BrokerTaskType getTaskType();

    @JsonProperty(value="shutdown_scheduled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Boolean> getShutdownScheduled();

    @JsonProperty(value="task_status")
    public abstract BalancerOperationStatus getBrokerTaskStatus();

    @JsonProperty(value="sub_task_statuses")
    public abstract BrokerSubTaskStatusesData getBrokerSubTaskStatuses();

    @JsonProperty(value="created_at")
    public abstract Instant getCreatedAt();

    @JsonProperty(value="updated_at")
    public abstract Instant getUpdatedAt();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    @JsonProperty(value="broker")
    public abstract Resource.Relationship getBroker();

    public static Builder builder() {
        return new AutoValue_BrokerTaskData.Builder().setKind("KafkaBrokerTask");
    }

    public static Builder fromBrokerTask(BrokerTask brokerTask) {
        return BrokerTaskData.builder().setClusterId(brokerTask.getClusterId()).setBrokerId(brokerTask.getBrokerId()).setTaskType(brokerTask.getTaskType()).setShutdownScheduled(brokerTask.getShutdownScheduled().orElse(null)).setBrokerTaskStatus(brokerTask.getBrokerTaskStatus()).setBrokerSubTaskStatuses(BrokerSubTaskStatusesData.fromBrokerSubTaskStatuses(brokerTask.getBrokerSubTaskStatuses())).setCreatedAt(brokerTask.getCreatedAt()).setUpdatedAt(brokerTask.getUpdatedAt()).setErrorCode(brokerTask.getErrorCode().orElse(null)).setErrorMessage(brokerTask.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static BrokerTaskData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="task_type") BrokerTaskType taskType, @JsonProperty(value="shutdown_scheduled") Boolean shutdownScheduled, @JsonProperty(value="task_status") BalancerOperationStatus taskStatus, @JsonProperty(value="sub_task_statuses") BrokerSubTaskStatusesData brokerSubTaskStatuses, @JsonProperty(value="created_at") Instant createdAt, @JsonProperty(value="updated_at") Instant updatedAt, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage, @JsonProperty(value="broker") Resource.Relationship broker) {
        return ((Builder)((Builder)BrokerTaskData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setBrokerId(brokerId).setTaskType(taskType).setShutdownScheduled(shutdownScheduled).setBrokerTaskStatus(taskStatus).setBrokerSubTaskStatuses(brokerSubTaskStatuses).setCreatedAt(createdAt).setUpdatedAt(updatedAt).setErrorCode(errorCode).setErrorMessage(errorMessage).setBroker(broker).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setTaskType(BrokerTaskType var1);

        public abstract Builder setShutdownScheduled(@Nullable Boolean var1);

        public abstract Builder setBrokerTaskStatus(BalancerOperationStatus var1);

        public abstract Builder setBrokerSubTaskStatuses(BrokerSubTaskStatusesData var1);

        public abstract Builder setCreatedAt(Instant var1);

        public abstract Builder setUpdatedAt(Instant var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract Builder setBroker(Resource.Relationship var1);

        public abstract BrokerTaskData build();
    }
}

