/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.LinkConfigManager;
import io.confluent.kafkarest.entities.v3.AlterLinkConfigBatchRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/links/{linkName}/configs:alter")
@ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.*")
public final class AlterLinkConfigBatchAction {
    private final Provider<LinkConfigManager> linkConfigManager;

    @Inject
    public AlterLinkConfigBatchAction(Provider<LinkConfigManager> linkConfigManager) {
        this.linkConfigManager = Objects.requireNonNull(linkConfigManager);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.link-configs.alter")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.alter")
    public void alterLink(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @QueryParam(value="validate_only") @DefaultValue(value="false") boolean validateOnly, @Valid AlterLinkConfigBatchRequest request) {
        CompletableFuture<Void> response = ((LinkConfigManager)this.linkConfigManager.get()).alterLinkConfigs(clusterId, linkName, request.getValue().toAlterConfigCommands(), validateOnly);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

