/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import com.google.common.collect.ImmutableList;
import io.confluent.common.logging.StructuredLogger;
import io.confluent.common.logging.StructuredLoggerImpl;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructuredLoggerFactory {
    private static final String DELIMITER = ".";
    private final String prefix;
    private final Map<String, StructuredLoggerImpl> loggers = new ConcurrentHashMap<String, StructuredLoggerImpl>();
    private final Function<String, Logger> inner;

    public StructuredLoggerFactory(String prefix) {
        this(prefix, LoggerFactory::getLogger);
    }

    StructuredLoggerFactory(String prefix, Function<String, Logger> inner) {
        this.prefix = prefix;
        this.inner = inner;
    }

    public StructuredLogger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public StructuredLogger getLogger(String name) {
        String loggerName = String.join((CharSequence)DELIMITER, this.prefix, name);
        return this.loggers.computeIfAbsent(loggerName, key -> new StructuredLoggerImpl(this.inner.apply((String)key)));
    }

    public Collection<String> getLoggers() {
        return ImmutableList.copyOf(this.loggers.keySet());
    }
}

