/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.io;

import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.exceptions.ConfluentHubClientException;
import io.confluent.connect.hub.io.Storage;
import io.confluent.connect.hub.utils.IOUtils;
import io.confluent.connect.hub.utils.NamingUtils;
import io.confluent.pluginregistry.rest.entities.PluginArchive;
import io.confluent.pluginregistry.rest.entities.PluginManifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ConfluentHubStorage
implements Storage {
    private static final String MD_5_ALG = "MD5";
    private static final String SHA_1_ALG = "SHA-1";
    public static final char PLUGIN_PATH_DELIMITER = ',';
    private static final String UNABLE_TO_DELETE_FILE_DIR_MSG = "Unable to delete file/directory";
    private static final String UNABLE_TO_CREATE_TMP_DIR_MSG = "Unable to create temporary directory";
    private static final String UNABLE_TO_LOAD_MANIFEST_FROM_FILE_MSG = "Unable to load component's manifest from a file";
    private static final String UNABLE_TO_CREATE_DIRECTORY_MSG = "Unable to create directory";
    private static final String UNABLE_TO_SCAN_MSG = "Unable to scan installation path";
    private static final String MD5_VERIFICATION_FAILED_MSG = "md5 checksum verification failed";
    private static final String SHA1_VERIFICATION_FAILED_MSG = "sha1 checksum verification failed";
    private static final String UNABLE_TO_COPY_DATA_MSG = "Unable to copy and verify data";
    private static final String UNABLE_TO_FIND_ALG_MSG = "Unable to find a cryptographic algorithm";
    private static final String INVALID_ARCHIVE_MSG = "The specified file is either empty or not an archive";
    private static final String UNABLE_TO_PROCESS_ARRAY_ENTRY_MSG = "Unable to extract entry: ";
    private static final String FILE_NOT_FOUND_MSG = "File '%s' was not found";
    private static final String UNABLE_TO_READ_FILE_MSG = "Unable to read file '%s'";
    private static final String UNABLE_TO_UPDATE_WORKER_CONFIG_MSG = "Unable to update Worker's configuration file %s";
    private static final String BAD_ENTRY_MSG = "Bad entry: ";

    @Override
    public void verifiedCopy(InputStream is, String outputFilePath, PluginArchive archive) {
        IOUtils.trace("Copying data from input stream to file {}", outputFilePath);
        try (DigestInputStream md5Is = new DigestInputStream(is, MessageDigest.getInstance(MD_5_ALG));
             DigestInputStream sha1Dis = new DigestInputStream(md5Is, MessageDigest.getInstance(SHA_1_ALG));
             FileOutputStream os = new FileOutputStream(outputFilePath);){
            long bytesCopied = org.apache.commons.io.IOUtils.copyLarge((InputStream)sha1Dis, (OutputStream)os);
            IOUtils.trace("{} bytes saved to disk", bytesCopied);
            byte[] md5Digest = md5Is.getMessageDigest().digest();
            byte[] sha1Digest = sha1Dis.getMessageDigest().digest();
            if (archive.getMd5() == null) {
                IOUtils.warn("Component doesn't have md5 checksum", new Object[0]);
            } else if (!archive.getMd5().equals(NamingUtils.byteArray2Hex(md5Digest))) {
                throw new ConfluentHubClientException(MD5_VERIFICATION_FAILED_MSG, ExitCode.SECURITY_ISSUES);
            }
            if (archive.getSha1() == null) {
                IOUtils.warn("Component doesn't have sha1 checksum", new Object[0]);
            } else if (!archive.getSha1().equals(NamingUtils.byteArray2Hex(sha1Digest))) {
                throw new ConfluentHubClientException(SHA1_VERIFICATION_FAILED_MSG, ExitCode.SECURITY_ISSUES);
            }
        }
        catch (IOException e) {
            throw new ConfluentHubClientException(UNABLE_TO_COPY_DATA_MSG, e, ExitCode.FS_RW);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfluentHubClientException(UNABLE_TO_FIND_ALG_MSG, e, ExitCode.UNKNOWN_ERROR);
        }
    }

    @Override
    public void unzip(File sourceFile, File outputDir) {
        IOUtils.trace("Unzipping file {} to {}", sourceFile.getPath(), outputDir.getPath());
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new ConfluentHubClientException("Failed to create output directory: " + outputDir, ExitCode.FS_RW);
        }
        try (ZipInputStream input = new ZipInputStream(new FileInputStream(sourceFile.getPath()));){
            this.unzip(input, outputDir);
        }
        catch (ConfluentHubClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfluentHubClientException("Failed to unzip '" + sourceFile + "' into '" + outputDir + "'", e, ExitCode.UNKNOWN_ERROR);
        }
    }

    private void unzip(ZipInputStream input, File outputDir) throws IOException {
        ZipEntry entry;
        long bytesCopied = 0L;
        String destinationDirCanonicalPath = outputDir.getCanonicalPath();
        while ((entry = input.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File destinationFile = new File(outputDir, entry.getName());
            String destinationFileCanonicalPath = destinationFile.getCanonicalPath();
            if (!destinationFileCanonicalPath.startsWith(destinationDirCanonicalPath)) {
                throw new ConfluentHubClientException(BAD_ENTRY_MSG + entry.getName(), ExitCode.ENTRY_OUTSIDE_TARGET_DIR);
            }
            String entryName = entry.getName().substring(entry.getName().indexOf(File.separatorChar));
            File file = new File(outputDir, entryName);
            File parent = file.getParentFile();
            this.createDirectories(parent.getPath());
            try {
                FileOutputStream output = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    bytesCopied += org.apache.commons.io.IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Exception e) {
                throw new ConfluentHubClientException(UNABLE_TO_PROCESS_ARRAY_ENTRY_MSG + entry.getName(), e, ExitCode.UNKNOWN_ERROR);
            }
        }
        input.closeEntry();
        if (bytesCopied == 0L) {
            throw new ConfluentHubClientException(INVALID_ARCHIVE_MSG, ExitCode.INVALID_OPTS_OR_ARGS);
        }
    }

    @Override
    public void delete(String path) {
        IOUtils.trace("Deleting {}", path);
        try {
            Path pathToDelete = Paths.get(path, new String[0]);
            Files.walk(pathToDelete, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new ConfluentHubClientException(UNABLE_TO_DELETE_FILE_DIR_MSG, e, ExitCode.FS_RW);
        }
    }

    @Override
    public void list(String path, Consumer<Path> consumer, boolean dirsOnly) {
        IOUtils.trace("Scanning path {}", path);
        try {
            if (dirsOnly) {
                Files.list(Paths.get(path, new String[0])).filter(p -> Files.isDirectory(p, new LinkOption[0])).forEach(consumer);
            } else {
                Files.list(Paths.get(path, new String[0])).forEach(consumer);
            }
        }
        catch (IOException e) {
            throw new ConfluentHubClientException(UNABLE_TO_SCAN_MSG, e, ExitCode.FS_RW);
        }
    }

    @Override
    public File createTmpDir(String prefix) {
        IOUtils.trace("Creating temporary directory", new Object[0]);
        try {
            Path tmpPath = Files.createTempDirectory(prefix, new FileAttribute[0]);
            File tmpDir = tmpPath.toFile();
            tmpDir.deleteOnExit();
            IOUtils.trace("Created temporary directory: {}", tmpDir.getPath());
            return tmpDir;
        }
        catch (IOException e) {
            throw new ConfluentHubClientException(UNABLE_TO_CREATE_TMP_DIR_MSG, e, ExitCode.FS_RW);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PluginManifest loadManifest(String path) {
        try (FileInputStream fis = new FileInputStream(path);){
            PluginManifest pluginManifest = PluginManifest.fromJson(fis);
            return pluginManifest;
        }
        catch (IOException e) {
            throw new ConfluentHubClientException(UNABLE_TO_LOAD_MANIFEST_FROM_FILE_MSG, e, ExitCode.FS_RW);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> readLines(String path) {
        try (FileInputStream is = new FileInputStream(path);){
            List lines;
            List list = lines = org.apache.commons.io.IOUtils.readLines((InputStream)is, (Charset)Charset.defaultCharset());
            return list;
        }
        catch (FileNotFoundException e) {
            throw new ConfluentHubClientException(String.format(FILE_NOT_FOUND_MSG, path), ExitCode.FS_RW);
        }
        catch (IOException e) {
            throw new ConfluentHubClientException(String.format(UNABLE_TO_READ_FILE_MSG, path), ExitCode.FS_RW);
        }
    }

    @Override
    public List<String> getPropertyValues(String path, String key) {
        try {
            PropertiesConfiguration pc = new PropertiesConfiguration(path);
            pc.setListDelimiter(',');
            String[] stringArray = pc.getStringArray(key);
            if (stringArray == null || stringArray.length == 0) {
                return new ArrayList<String>();
            }
            return new ArrayList<String>(Arrays.asList(stringArray));
        }
        catch (ConfigurationException e) {
            throw new ConfluentHubClientException(String.format(UNABLE_TO_UPDATE_WORKER_CONFIG_MSG, path), (Exception)((Object)e), ExitCode.UNKNOWN_ERROR);
        }
    }

    @Override
    public void updateConfig(String path, String key, List<String> values) {
        try {
            PropertiesConfiguration pc = new PropertiesConfiguration(path);
            pc.setListDelimiter(',');
            pc.setProperty(key, values);
            pc.save();
        }
        catch (ConfigurationException e) {
            throw new ConfluentHubClientException(String.format(UNABLE_TO_UPDATE_WORKER_CONFIG_MSG, path), (Exception)((Object)e), ExitCode.UNKNOWN_ERROR);
        }
    }

    @Override
    public String getParentDirectoryPath(String absPath) {
        if (!this.exists(absPath)) {
            throw new ConfluentHubClientException(String.format(FILE_NOT_FOUND_MSG, absPath), ExitCode.FS_RW);
        }
        Path path = Paths.get(absPath, new String[0]);
        Path parent = path.getParent();
        Path result = path.toFile().isDirectory() ? parent : parent.getParent();
        return result.toFile().getAbsolutePath();
    }

    @Override
    public boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    @Override
    public void createDirectories(String path) {
        IOUtils.trace("Creating directory recursively: {}", path);
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            IOUtils.error(e.getMessage(), new Object[0]);
            throw new ConfluentHubClientException(UNABLE_TO_CREATE_DIRECTORY_MSG, e, ExitCode.FS_RW);
        }
    }
}

