/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.utils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final String USER_INPUT_PLACEHOLDER = " ";
    private static final String YES_NO_OPTIONS_MSG = " (yN)";
    private static final String YES_OPTION = "y";
    private static final String NO_OPTION = "n";
    private static final String LOG_MSG_INDENTATION = "  ";
    private static final String INVALID_RANGE_MSG = "Number must be in the range %d to %d";
    static Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    public static void setupLogger(boolean verbose) {
        if (verbose) {
            LogManager.getRootLogger().setLevel(Level.TRACE);
        } else {
            LogManager.getRootLogger().setLevel(Level.INFO);
        }
    }

    private static void info(String msgOffSet, String format, Object ... arguments) {
        LOG.info(msgOffSet + format, arguments);
    }

    public static void info(String format, Object ... arguments) {
        LOG.info(format, arguments);
    }

    public static void indentedInfo(String format, Object ... arguments) {
        LOG.info(LOG_MSG_INDENTATION + format, arguments);
    }

    public static void trace(String format, Object ... arguments) {
        LOG.trace(format, arguments);
    }

    public static void error(String format, Object ... arguments) {
        LOG.error(format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        LOG.warn(format, arguments);
    }

    public static boolean readYesNo(String question) {
        System.out.print(question + YES_NO_OPTIONS_MSG + USER_INPUT_PLACEHOLDER);
        Scanner consoleScanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
        while (true) {
            String answer;
            if (YES_OPTION.equals((answer = consoleScanner.nextLine()).toLowerCase())) {
                System.out.println();
                return true;
            }
            if (NO_OPTION.equals(answer.toLowerCase())) {
                System.out.println();
                return false;
            }
            System.out.print(question + YES_NO_OPTIONS_MSG + USER_INPUT_PLACEHOLDER);
        }
    }

    public static boolean readYesNoDefault(String defaultQuestionFormat, String defaultValue) {
        System.out.print(String.format(defaultQuestionFormat, defaultValue) + YES_NO_OPTIONS_MSG + USER_INPUT_PLACEHOLDER);
        Scanner consoleScanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
        while (true) {
            String answer;
            if (YES_OPTION.equals((answer = consoleScanner.nextLine()).toLowerCase())) {
                System.out.println();
                return true;
            }
            if (NO_OPTION.equals(answer.toLowerCase())) {
                System.out.println();
                return false;
            }
            System.out.print(String.format(defaultQuestionFormat, defaultValue) + YES_NO_OPTIONS_MSG + USER_INPUT_PLACEHOLDER);
        }
    }

    public static IntStream readMultipleChoices(List<Pair<String, String>> options, String header, String allQuestion, String oneQuestionFormat) {
        LOG.info(header);
        IntStream.range(1, options.size() + 1).forEach(i -> IOUtils.indentedInfo("{}. {}: {}", i, ((Pair)options.get(i - 1)).getKey(), ((Pair)options.get(i - 1)).getValue()));
        boolean selectAll = IOUtils.readYesNo(allQuestion);
        if (selectAll) {
            return IntStream.range(0, options.size());
        }
        IntStream.Builder builder = IntStream.builder();
        IntStream.range(0, options.size()).forEach(i -> {
            boolean selected;
            if (selected = IOUtils.readYesNo(String.format(oneQuestionFormat, ++i))) {
                builder.accept(i - 1);
            }
        });
        System.out.println();
        return builder.build();
    }

    public static <C, D> Pair<C, D> readOneChoice(List<Pair<C, D>> options, String header, String messageFormat) {
        LOG.info(header);
        IntStream.range(1, options.size() + 1).forEach(i -> IOUtils.indentedInfo("{}. {} {}", i, ((Pair)options.get(i - 1)).getKey(), ((Pair)options.get(i - 1)).getValue()));
        Integer selectedIndex = IOUtils.readInteger(messageFormat, 1, options.size());
        return options.get(selectedIndex - 1);
    }

    private static Integer readInteger(String messageFormat, int fromInclusive, int toInclusive) {
        String range = fromInclusive != toInclusive ? String.format("%s-%s", fromInclusive, toInclusive) : String.format("%s", fromInclusive);
        System.out.print(String.format(messageFormat, range) + USER_INPUT_PLACEHOLDER);
        Scanner consoleScanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
        while (true) {
            String answer = consoleScanner.nextLine();
            try {
                Integer parsedAnswer = Integer.parseInt(answer);
                if (parsedAnswer < fromInclusive || parsedAnswer > toInclusive) {
                    System.out.println(String.format(INVALID_RANGE_MSG, fromInclusive, toInclusive));
                    continue;
                }
                return parsedAnswer;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    public static String readString(String message) {
        System.out.print(message + USER_INPUT_PLACEHOLDER);
        Scanner consoleScanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
        String answer = consoleScanner.nextLine();
        return answer;
    }
}

