/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class PluginFeatures
implements Comparable<PluginFeatures> {
    @JsonProperty(value="supported_encodings")
    private Set<String> supportedEncodings;
    @JsonProperty(value="single_message_transforms")
    private Boolean singleMessageTransforms;
    @JsonProperty(value="confluent_control_center_integration")
    private Boolean confluentControlCenterIntegration;
    @JsonProperty(value="kafka_connect_api")
    private Boolean kafkaConnectApi;
    @JsonProperty(value="delivery_guarantee")
    private Set<String> deliveryGuarantee;

    public static PluginFeatures fromJson(String json) throws IOException {
        return (PluginFeatures)JsonUtil.newObjectMapper().readValue(json, PluginFeatures.class);
    }

    public PluginFeatures() {
    }

    public PluginFeatures(Set<String> supportedEncodings, Boolean singleMessageTransforms, Boolean confluentControlCenterIntegration, Boolean kafkaConnectApi, Set<String> deliveryGuarantee) {
        this.supportedEncodings = supportedEncodings;
        this.singleMessageTransforms = singleMessageTransforms;
        this.confluentControlCenterIntegration = confluentControlCenterIntegration;
        this.kafkaConnectApi = kafkaConnectApi;
        this.deliveryGuarantee = deliveryGuarantee;
    }

    public PluginFeatures(PluginFeatures original) {
        this.setSupportedEncodings(original.supportedEncodings);
        this.setSingleMessageTransforms(original.singleMessageTransforms);
        this.setConfluentControlCenterIntegration(original.confluentControlCenterIntegration);
        this.setKafkaConnectApi(original.kafkaConnectApi);
        this.setDeliveryGuarantee(original.deliveryGuarantee);
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public Set<String> getSupportedEncodings() {
        return this.supportedEncodings;
    }

    public void setSupportedEncodings(Set<String> supportedEncodings) {
        this.supportedEncodings = supportedEncodings != null ? new HashSet<String>(supportedEncodings) : null;
    }

    public Boolean getSingleMessageTransforms() {
        return this.singleMessageTransforms;
    }

    public void setSingleMessageTransforms(Boolean singleMessageTransforms) {
        this.singleMessageTransforms = singleMessageTransforms;
    }

    public Boolean getConfluentControlCenterIntegration() {
        return this.confluentControlCenterIntegration;
    }

    public void setConfluentControlCenterIntegration(Boolean confluentControlCenterIntegration) {
        this.confluentControlCenterIntegration = confluentControlCenterIntegration;
    }

    public Boolean getKafkaConnectApi() {
        return this.kafkaConnectApi;
    }

    public void setKafkaConnectApi(Boolean kafkaConnectApi) {
        this.kafkaConnectApi = kafkaConnectApi;
    }

    public Set<String> getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public void setDeliveryGuarantee(Set<String> deliveryGuarantee) {
        this.deliveryGuarantee = deliveryGuarantee;
    }

    public int hashCode() {
        return Objects.hash(this.supportedEncodings, this.singleMessageTransforms, this.confluentControlCenterIntegration, this.kafkaConnectApi, this.deliveryGuarantee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginFeatures that = (PluginFeatures)o;
        return ObjectUtil.equals(this.supportedEncodings, that.supportedEncodings) && ObjectUtil.equals(this.singleMessageTransforms, that.singleMessageTransforms) && ObjectUtil.equals(this.confluentControlCenterIntegration, that.confluentControlCenterIntegration) && ObjectUtil.equals(this.kafkaConnectApi, that.kafkaConnectApi) && ObjectUtil.equals(this.deliveryGuarantee, that.deliveryGuarantee);
    }

    @Override
    public int compareTo(PluginFeatures that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.supportedEncodings, that.supportedEncodings);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.singleMessageTransforms, that.singleMessageTransforms);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.confluentControlCenterIntegration, that.confluentControlCenterIntegration);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.kafkaConnectApi, that.kafkaConnectApi);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.deliveryGuarantee, that.deliveryGuarantee);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{supported_encodings=" + this.supportedEncodings + ",");
        sb.append("single_message_transforms=" + this.singleMessageTransforms + ",");
        sb.append("confluent_control_center_integration=" + this.confluentControlCenterIntegration + ",");
        sb.append("kafka_connect_api=" + this.kafkaConnectApi + ",");
        sb.append("exactly_once=" + this.deliveryGuarantee + "}");
        return sb.toString();
    }
}

