/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import com.sun.security.auth.module.Krb5LoginModule;
import io.confluent.common.security.auth.RestSecurityContext;
import io.confluent.common.security.sasl.JaasConfigProvider;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SecureConfigProvider;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;

public final class SaslSecureConfigProvider
implements SecureConfigProvider {
    private static final Map<String, String> loginModuleToMechanismMap = new HashMap<String, String>();

    private static void populateLoginModuleToMechanismMap() {
        loginModuleToMechanismMap.put(Krb5LoginModule.class.getName(), "GSSAPI");
        loginModuleToMechanismMap.put(PlainLoginModule.class.getName(), "PLAIN");
        loginModuleToMechanismMap.put(ScramLoginModule.class.getName(), "SCRAM-SHA-512");
    }

    public SaslSecureConfigProvider() {
        JaasConfigProvider.getInstance().initialize();
    }

    @Override
    public Properties getProducerProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        return this.getSaslClientProperties(secureKafkaRestConfig);
    }

    @Override
    public Properties getConsumerProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        return this.getSaslClientProperties(secureKafkaRestConfig);
    }

    @Override
    public Properties getAdminProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        return this.getSaslClientProperties(secureKafkaRestConfig);
    }

    @Override
    public boolean isPrincipalAvailable(Principal principal, ConfluentSecureKafkaRestConfig kafkaRestConfig, String resourceTyp) {
        return JaasConfigProvider.getInstance().getJaasConfig(principal.getName()) != null;
    }

    private Properties getSaslClientProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        Properties properties = new Properties();
        if (RestSecurityContext.getCurrentSecurityContext() != null && RestSecurityContext.getCurrentSecurityContext().getUserPrincipal() != null) {
            String principal = RestSecurityContext.getCurrentSecurityContext().getUserPrincipal().getName();
            JaasConfigProvider.JaasConfig jaasConfig = JaasConfigProvider.getInstance().getJaasConfig(principal);
            if (jaasConfig != null) {
                properties.setProperty("sasl.jaas.config", jaasConfig.getConfiguration());
                if (jaasConfig.getOption("mechanism") != null) {
                    properties.put("sasl.mechanism", jaasConfig.getOption("mechanism"));
                } else {
                    properties.put("sasl.mechanism", loginModuleToMechanismMap.get(jaasConfig.getLoginModule()));
                }
            }
        }
        return properties;
    }

    static {
        SaslSecureConfigProvider.populateLoginModuleToMechanismMap();
    }
}

