/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.command.record.Command;
import io.confluent.license.LicenseManagerPurpose;
import io.confluent.license.LicenseStore;
import java.util.Map;

public class LicenseStoreFactory {
    public static LicenseStore createAddOnLicenseStore(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, LicenseManagerPurpose purpose) {
        switch (purpose) {
            case CSFLE: {
                return LicenseStoreFactory.createCSFLELicenseStore(topic, producerConfig, consumerConfig, topicConfig);
            }
        }
        throw new IllegalArgumentException("Unknown license purpose: " + String.valueOf((Object)purpose));
    }

    private static LicenseStore createCSFLELicenseStore(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig) {
        Command.CommandKey commandKey = Command.CommandKey.newBuilder().setConfigType(Command.CommandConfigType.CSFLE_LICENSE_INFO).setGuid("CONFLUENT_CSFLE_LICENSE").build();
        return new LicenseStore(topic, producerConfig, consumerConfig, topicConfig, commandKey);
    }
}

