/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.license.AddOnLicenseManager;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseAutoGenerationPolicy;
import io.confluent.license.LicenseChanged;
import io.confluent.license.LicenseManager;
import io.confluent.license.LicenseManagerPurpose;
import io.confluent.license.LicenseStoreFactory;
import io.confluent.license.store.ConfluentLicenseStore;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrialOnlyLicenseManager
implements AddOnLicenseManager {
    private static final Logger log = LoggerFactory.getLogger(TrialOnlyLicenseManager.class);
    private final ConfluentLicenseStore trialOnlyLicenseStore;
    private final LicenseManager delegate;

    public TrialOnlyLicenseManager(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String licenseGuid) {
        if (licenseGuid == null || licenseGuid.trim().isEmpty()) {
            throw new IllegalArgumentException("The license GUID provided cannot be null or empty");
        }
        this.trialOnlyLicenseStore = LicenseStoreFactory.createTrialOnlyLicenseStore(topic, producerConfig, consumerConfig, topicConfig, licenseGuid);
        this.delegate = new LicenseManager(this.trialOnlyLicenseStore, null, LicenseAutoGenerationPolicy.TRIAL_ONLY);
        this.trialOnlyLicenseStore.start();
    }

    public TrialOnlyLicenseManager(ConfluentLicenseStore store, Time time) {
        this.trialOnlyLicenseStore = store;
        this.delegate = new LicenseManager(this.trialOnlyLicenseStore, null, LicenseManagerPurpose.PRIMARY, time, LicenseAutoGenerationPolicy.TRIAL_ONLY);
        this.trialOnlyLicenseStore.start();
    }

    @Override
    public License registerOrValidateAddOnLicense(String license) throws InvalidLicenseException {
        return this.delegate.registerOrValidateAddOnLicense(license);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public boolean addListener(Consumer<LicenseChanged> listener) {
        return this.delegate.addListener(listener);
    }
}

