/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAuthenticator
extends LoginAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(CompositeAuthenticator.class);
    private final Authenticator http;
    private final Authenticator x509;
    private final boolean allowAnonymousUser;

    public CompositeAuthenticator(Authenticator http, Authenticator x509, boolean allowAnonymousUser) {
        this.http = http;
        this.x509 = x509;
        this.allowAnonymousUser = allowAnonymousUser;
    }

    public String getAuthMethod() {
        return "BEARER+BASIC+X509";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        log.debug("Processing composite authentication");
        HttpServletRequest request = (HttpServletRequest)req;
        if (request.getHeader(HttpHeader.AUTHORIZATION.asString()) != null) {
            log.debug("AUTHORIZATION header present, processing HTTP authorization");
            return this.http.validateRequest(req, res, mandatory);
        }
        log.debug("Attempting to execute certificate authentication");
        Authentication authentication = this.x509.validateRequest(req, res, mandatory);
        if (authentication != Authentication.NOT_CHECKED) {
            log.debug("Valid certificate found, processing mTLS authorization");
            return authentication;
        }
        if (this.allowAnonymousUser) {
            log.debug("No authentication data provided, continuing as anonymous");
            return Authentication.NOT_CHECKED;
        }
        log.debug("No certificate authorization, processing HTTP authorization");
        return this.http.validateRequest(req, res, mandatory);
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        this.http.setConfiguration(configuration);
        this.x509.setConfiguration(configuration);
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    public boolean isAllowAnonymousUser() {
        return this.allowAnonymousUser;
    }
}

