/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.CertificatePrincipal;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeLoginService
extends AbstractLoginService {
    private static final Logger log = LoggerFactory.getLogger(CompositeLoginService.class);
    private final LoginService http;
    private final LoginService x509;

    public CompositeLoginService(LoginService http, LoginService x509) {
        this.http = http;
        this.x509 = x509;
        super.setIdentityService(null);
    }

    public UserIdentity login(String userName, Object credentials, ServletRequest request) {
        if (credentials instanceof X509Certificate) {
            log.debug("Credentials provided as X509 certificate, processing to the certificate authorization");
            return this.x509.login(userName, credentials, request);
        }
        log.debug("Processing to the HTTP authorization");
        return this.http.login(userName, credentials, request);
    }

    public boolean validate(UserIdentity user) {
        if (!user.getSubject().getPrincipals(CertificatePrincipal.class).isEmpty()) {
            log.debug("Claimed identity contains certificate principal, processing to the certificate validation");
            return this.x509.validate(user);
        }
        log.debug("Processing to the HTTP validation");
        return this.http.validate(user);
    }

    public void logout(UserIdentity user) {
        if (!user.getSubject().getPrincipals(CertificatePrincipal.class).isEmpty()) {
            this.x509.logout(user);
        } else {
            this.http.logout(user);
        }
    }

    public void setIdentityService(IdentityService identityService) {
        this.x509.setIdentityService(identityService);
        this.http.setIdentityService(identityService);
        super.setIdentityService(identityService);
    }

    protected AbstractLoginService.UserPrincipal loadUserInfo(String s) {
        throw new UnsupportedOperationException("loadUserInfo");
    }

    protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal userPrincipal) {
        throw new UnsupportedOperationException("loadRoleInfo");
    }

    protected void doStart() throws Exception {
        if (this.http instanceof LifeCycle) {
            ((LifeCycle)this.http).start();
        }
        if (this.x509 instanceof LifeCycle) {
            ((LifeCycle)this.x509).start();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.x509 instanceof LifeCycle) {
            ((LifeCycle)this.x509).stop();
        }
        if (this.http instanceof LifeCycle) {
            ((LifeCycle)this.http).stop();
        }
        super.doStop();
    }
}

