/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.security.auth.client.rest.RestClient;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.RolePrincipal;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsBasicLoginService
extends AbstractLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdsBasicLoginService.class);
    private final String realmName;
    private RestClient restClient;
    private MetricsContainer metricsContainer;

    public MdsBasicLoginService(Map<String, ?> map, String realmName) {
        this.realmName = realmName;
        this.restClient = new RestClient(map);
    }

    public UserIdentity login(String userName, Object credentials, Request request, Function<Boolean, Session> getOrCreateSession) {
        UserIdentity userIdentity;
        block4: {
            long loginStartTime = System.nanoTime();
            userIdentity = null;
            log.trace("Login attempt for user {}", (Object)userName);
            try {
                String userInfo = userName + ":" + String.valueOf(credentials);
                OAuthBearerToken idToken = this.restClient.login(userInfo);
                if (idToken == null) {
                    log.error("Login failed for " + userName);
                    return null;
                }
                Subject subject = new Subject();
                JwtPrincipal principal = new JwtPrincipal(idToken);
                subject.getPrincipals().add(principal);
                userIdentity = this._identityService.newUserIdentity(subject, (Principal)principal, new String[0]);
                log.trace("User identity created on subject {}", (Object)subject);
                if (Objects.nonNull(this.metricsContainer)) {
                    this.metricsContainer.getBasicSuccessLoginCount().record();
                    this.metricsContainer.getBasicSuccessLoginLatency().record((double)(System.nanoTime() - loginStartTime) / 1000.0);
                }
            }
            catch (Exception e) {
                log.error("Login failed for " + userName, (Throwable)e);
                if (!Objects.nonNull(this.metricsContainer)) break block4;
                this.metricsContainer.getBasicFailedLoginCount().record();
                this.metricsContainer.getBasicFailedLoginLatency().record((double)(System.nanoTime() - loginStartTime) / 1000.0);
            }
        }
        return userIdentity;
    }

    public String getName() {
        return this.realmName;
    }

    protected UserPrincipal loadUserInfo(String s) {
        throw new UnsupportedOperationException("loadUserInfo");
    }

    protected List<RolePrincipal> loadRoleInfo(UserPrincipal userPrincipal) {
        throw new UnsupportedOperationException("loadRoleInfo");
    }

    void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public MdsBasicLoginService withMetricsContainer(MetricsContainer metricsContainer) {
        this.metricsContainer = metricsContainer;
        return this;
    }
}

