/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth.schemaregistry;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class SchemaRegistryClientAssertionConfig
extends AbstractConfig {
    public static final String OAUTH_CONFIG_PREFIX = "bearer";
    public static final String BEARER_CLIENTASSERTION_ISSUER = "bearer.assertion.claim.iss";
    public static final String BEARER_CLIENTASSERTION_ISSUER_DOC = "The value to be added to the Issuer claim \"iss\" which will be included in the client assertion created locally";
    public static final String BEARER_CLIENTASSERTION_SUBJECT = "bearer.assertion.claim.sub";
    public static final String BEARER_CLIENTASSERTION_SUBJECT_DOC = "The value to be added to the Subject claim \"sub\" which will be included in the client assertion created locally";
    public static final String BEARER_CLIENTASSERTION_AUDIENCE = "bearer.assertion.claim.aud";
    public static final String BEARER_CLIENTASSERTION_AUDIENCE_DOC = "The value to be added to the Audience claim \"aud\" which will be included in the client assertion created locally";
    public static final String BEARER_CLIENTASSERTION_INCLUDE_JTI_CLAIM = "bearer.assertion.claim.jti.include";
    public static final String BEARER_CLIENTASSERTION_INCLUDE_JTI_CLAIM_DOC = "The (optional) setting for specifying whether to include jti claim or not";
    public static final String BEARER_CLIENTASSERTION_INCLUDE_NBF_CLAIM = "bearer.assertion.claim.nbf.include";
    public static final String BEARER_CLIENTASSERTION_INCLUDE_NBF_CLAIM_DOC = "The (optional) setting for specifying whether to include \"not before\" (nbf) claim or notIf set to true, nbf claim with (current time - 1 minute) will be included in the client assertion";
    public static final String BEARER_CLIENTASSERTION_PRIVATE_KEY = "bearer.assertion.private.key.file";
    public static final String BEARER_CLIENTASSERTION_PRIVATE_KEY_DOC = "The location for the private key to be used for signing client assertion in PEM formatRequired for local client assertion creation";
    public static final String BEARER_CLIENTASSERTION_PRIVATE_KEY_PASSPHRASE = "bearer.assertion.private.key.passphrase";
    public static final String BEARER_CLIENTASSERTION_PRIVATE_KEY_PASSPHRASE_DOC = "The passphrase required for decrypting the private key (in case of PKCS#8 format pem file) ";
    public static final String BEARER_CLIENTASSERTION_EXPIRATION = "bearer.assertion.claim.exp.minutes";
    public static final String BEARER_CLIENTASSERTION_EXPIRATION_DOC = "The (Optional) expiration time for the client assertion in minutesThe default value is 5 minutes";
    public static final String BEARER_CLIENTASSERTION_LOCATION = "bearer.assertion.file";
    public static final String BEARER_CLIENTASSERTION_LOCATION_DOC = "The location/path on disc at which a signed client assertion is presentThis will be passed directly to the token endpoint.";
    public static final String BEARER_CLIENTASSERTION_HEADER_VALUES_PATH = "bearer.assertion.template.file";
    public static final String BEARER_CLIENTASSERTION_HEADER_VALUES_PATH_DOC = "The location for the JSON file which contains additional header and payload claims to be included in the client assertion";

    public static ConfigDef clientAssertionConfigDef() {
        ConfigDef configDef = new ConfigDef().define(BEARER_CLIENTASSERTION_ISSUER, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_ISSUER_DOC).define(BEARER_CLIENTASSERTION_SUBJECT, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_SUBJECT_DOC).define(BEARER_CLIENTASSERTION_AUDIENCE, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_AUDIENCE_DOC).define(BEARER_CLIENTASSERTION_INCLUDE_JTI_CLAIM, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_INCLUDE_JTI_CLAIM_DOC).define(BEARER_CLIENTASSERTION_INCLUDE_NBF_CLAIM, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_INCLUDE_NBF_CLAIM_DOC).define(BEARER_CLIENTASSERTION_EXPIRATION, ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_EXPIRATION_DOC).define(BEARER_CLIENTASSERTION_PRIVATE_KEY, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_PRIVATE_KEY_DOC).define(BEARER_CLIENTASSERTION_PRIVATE_KEY_PASSPHRASE, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_PRIVATE_KEY_PASSPHRASE_DOC).define(BEARER_CLIENTASSERTION_LOCATION, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_LOCATION_DOC).define(BEARER_CLIENTASSERTION_HEADER_VALUES_PATH, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, BEARER_CLIENTASSERTION_HEADER_VALUES_PATH_DOC);
        return configDef;
    }

    public SchemaRegistryClientAssertionConfig(Map<?, ?> props) {
        super(SchemaRegistryClientAssertionConfig.clientAssertionConfigDef(), props);
    }

    public Map<String, ?> saslClientConfigs() {
        HashMap configsWithSaslPrefix = new HashMap();
        this.values().forEach((k, v) -> configsWithSaslPrefix.put("sasl.oauth" + k, v));
        return configsWithSaslPrefix;
    }
}

