/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class ConnectConstraintSecurityHandler
extends ConstraintSecurityHandler {
    private static final Set<RequestMatcher> INTERNAL_REQUEST_MATCHERS = new HashSet<RequestMatcher>(Arrays.asList(new RequestMatcher("POST", "/?connectors/([^/]+)/tasks/?"), new RequestMatcher("PUT", "/?connectors/[^/]+/fence/?")));

    private static boolean isInternalRequest(Request request) {
        return INTERNAL_REQUEST_MATCHERS.stream().anyMatch(m -> m.test(request));
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (ConnectConstraintSecurityHandler.isInternalRequest(request)) {
            return this.getHandler().handle(request, response, callback);
        }
        return super.handle(request, response, callback);
    }

    private static class RequestMatcher
    implements Predicate<Request> {
        private final String method;
        private final Pattern path;

        public RequestMatcher(String method, String path) {
            this.method = method;
            this.path = Pattern.compile(path);
        }

        @Override
        public boolean test(Request request) {
            return request.getMethod().equalsIgnoreCase(this.method) && this.path.matcher(request.getHttpURI().getPath()).matches();
        }
    }
}

