/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.license;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractScheduledService;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseBackgroundFetcher
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(LicenseBackgroundFetcher.class);
    private static final int DEFAULT_REFRESH_INTERVAL_MS = 30000;
    private final int refreshIntervalMs;
    private final String topic;
    private final Map<String, Object> producerConfig;
    private final Map<String, Object> consumerConfig;
    private final Map<String, Object> topicConfig;
    private final String license;
    private LicenseManager licenseManager;
    private final AtomicReference<License> cacheLicense = new AtomicReference();

    public LicenseBackgroundFetcher(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String license) {
        this(topic, producerConfig, consumerConfig, topicConfig, license, 30000);
    }

    @VisibleForTesting
    LicenseBackgroundFetcher(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String license, int refreshIntervalMs) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.consumerConfig = consumerConfig;
        this.topicConfig = topicConfig;
        this.license = license;
        this.refreshIntervalMs = refreshIntervalMs;
    }

    public boolean hasValidLicense() {
        License license = this.cacheLicense.get();
        return license != null && license.isValid();
    }

    @VisibleForTesting
    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        this.runOneIteration();
    }

    public void shutDown() {
        if (this.licenseManager != null) {
            log.info("Shutting down License Manager...");
            this.licenseManager.stop();
        }
    }

    protected void runOneIteration() {
        try {
            if (this.licenseManager == null) {
                log.info("Setting up License Manager...");
                this.licenseManager = new LicenseManager(this.topic, this.producerConfig, this.consumerConfig, this.topicConfig);
                log.info("Finished setting up License Manager.");
            }
            this.cacheLicense.set(this.licenseManager.registerOrValidateLicense(this.license));
        }
        catch (InvalidLicenseException e) {
            log.error("License validation failed", (Throwable)e);
            this.cacheLicense.set(null);
        }
        catch (Exception e) {
            log.error("Can not validate license due to", (Throwable)e);
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)0L, (long)this.refreshIntervalMs, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

