/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.license;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.common.security.license.LicenseBackgroundFetcher;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import java.util.Map;

@Priority(value=1)
public class LicenseValidatorFilter
implements ContainerRequestFilter {
    private final LicenseBackgroundFetcher licenseBackgroundFetcher;

    public LicenseValidatorFilter(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String license) {
        this.licenseBackgroundFetcher = new LicenseBackgroundFetcher(topic, producerConfig, consumerConfig, topicConfig, license);
        this.licenseBackgroundFetcher.startAsync();
    }

    public void filter(ContainerRequestContext requestContext) {
        if (!this.licenseBackgroundFetcher.hasValidLicense()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.PAYMENT_REQUIRED).entity((Object)"Invalid License!").build());
        }
    }

    @VisibleForTesting
    public LicenseBackgroundFetcher getLicenseBackgroundFetcher() {
        return this.licenseBackgroundFetcher;
    }

    public void stopLicenseManager() {
        this.licenseBackgroundFetcher.stopAsync();
    }
}

