/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.license;

import io.confluent.common.security.license.MultiLicenseBackgroundFetcher;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.kafka.BrokerType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLicenseInitializer {
    private static final Logger log = LoggerFactory.getLogger(MultiLicenseInitializer.class);

    public static List<License> registerOrGenerateNewLicense(MultiLicenseBackgroundFetcher fetcher, BrokerType brokerType, String licenseString) {
        try {
            log.debug("Performing initial license validation");
            List<Object> registeredLicenses = new ArrayList();
            try {
                registeredLicenses = fetcher.registerLicenseThenNotify(licenseString, true);
                log.debug("Initial license validation returned {} licenses.", registeredLicenses);
            }
            catch (InvalidLicenseException e) {
                log.warn("No Licenses Found");
            }
            if (brokerType != BrokerType.CONFLUENT_CLOUD && !MultiLicenseInitializer.hasValidCpLicense(registeredLicenses)) {
                log.info("No valid CP license found for broker type '{}'.Checking if trial license can be registered.", (Object)brokerType);
                registeredLicenses = fetcher.registerLicenseThenNotify("", false);
            }
            log.debug("Initial license broker checks completed successfully.");
            return registeredLicenses;
        }
        catch (InvalidLicenseException e) {
            fetcher.notifyListeners(listener -> listener.onLicenseValidationFailure(e));
        }
        catch (Exception e) {
            log.error("Unexpected error during license validation", (Throwable)e);
        }
        return null;
    }

    public static boolean hasValidCpLicense(List<License> licenses) {
        return licenses != null && licenses.stream().anyMatch(license -> license.deploymentScope() == License.DeploymentScope.CP && license.isValid());
    }

    public static boolean hasOnlyValidCpForCcLicense(List<License> licenses) {
        return licenses != null && !licenses.isEmpty() && licenses.stream().allMatch(license -> license.deploymentScope() == License.DeploymentScope.CP_FOR_CC && license.isValid());
    }
}

