/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.ssl;

import io.confluent.common.security.auth.RestSecurityContext;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public final class PrincipalAliasedX509KeyManager
extends X509ExtendedKeyManager {
    private X509KeyManager defaultKeyManager;
    private Map<String, String> userToAliasMap;

    public PrincipalAliasedX509KeyManager(Map<String, String> userToAliasMap, X509KeyManager keyManager) {
        this.userToAliasMap = userToAliasMap;
        this.defaultKeyManager = keyManager;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String user = null;
        if (RestSecurityContext.getCurrentSecurityContext() != null) {
            user = RestSecurityContext.getCurrentSecurityContext().getUserPrincipal().getName();
        }
        return this.userToAliasMap.containsKey(user) ? this.userToAliasMap.get(user) : this.defaultKeyManager.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.defaultKeyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.defaultKeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.defaultKeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.defaultKeyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.defaultKeyManager.getPrivateKey(alias);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }
}

