/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.serializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.util.JsonFormat;
import io.confluent.serializers.UberSerde;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoSerde<T extends Message>
implements UberSerde<T>,
Serde<T>,
Deserializer<T>,
Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(ProtoSerde.class);
    private final Parser<T> parser;
    private final T instance;

    public ProtoSerde(T instance) {
        this.instance = instance;
        this.parser = instance.getParserForType();
    }

    @Override
    public Class<T> type() {
        return this.instance.getClass();
    }

    @Override
    public byte[] serialize(T message) {
        return this.serializeUntyped((Message)message);
    }

    public byte[] serialize(String topic, T data) {
        return this.serialize(data);
    }

    private byte[] serializeUntyped(Message message) {
        if (message == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocate(message.getSerializedSize() + 1);
            CodedOutputStream cos = CodedOutputStream.newInstance((ByteBuffer)buffer);
            cos.writeRawByte((byte)127);
            message.writeTo(cos);
            cos.flush();
            return buffer.array();
        }
        catch (Exception e) {
            String errMsg = "Error serializing protobuf message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    @Override
    public T deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            CodedInputStream cis = CodedInputStream.newInstance((ByteBuffer)buffer);
            byte magic = cis.readRawByte();
            if (127 != magic) {
                String errMsg = String.format("Tried to deserialize message with unknown magic byte %s", magic);
                log.error(errMsg);
                throw new SerializationException(errMsg);
            }
            return (T)((Message)this.parser.parseFrom(cis));
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Error deserializing protobuf message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    public T deserialize(String topic, byte[] data) {
        return this.deserialize(data);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public void close() {
    }

    public Serializer<T> serializer() {
        return this;
    }

    public Deserializer<T> deserializer() {
        return this;
    }

    @Override
    public byte[] fromJson(String json) {
        Message.Builder builder = this.instance.newBuilderForType();
        try {
            JsonFormat.parser().merge(json, builder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("JSON parsing failed: " + e.getMessage(), (Throwable)e);
        }
        return this.serializeUntyped(builder.build());
    }

    @Override
    public String toJson(T obj) {
        return this.toJson(obj, false);
    }

    public String toJson(T obj, boolean preseveFieldName) {
        try {
            if (preseveFieldName) {
                return JsonFormat.printer().alwaysPrintFieldsWithNoPresence().omittingInsignificantWhitespace().preservingProtoFieldNames().print(obj);
            }
            return JsonFormat.printer().alwaysPrintFieldsWithNoPresence().omittingInsignificantWhitespace().print(obj);
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("JSON formatting failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

