/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.atlas.repository.graph.CfltFullTextMapperV2;
import io.confluent.catalog.atlas.repository.graphdb.janus.CfltAtlasJanusGraph;
import io.confluent.catalog.atlas.repository.graphdb.janus.CfltAtlasJanusGraphDatabase;
import io.confluent.catalog.atlas.repository.store.graph.v2.CfltAtlasEntityStoreV2;
import io.confluent.catalog.atlas.repository.store.graph.v2.CfltAtlasTypeDefGraphStoreV2;
import io.confluent.catalog.atlas.repository.store.graph.v2.CfltEntityGraphRetriever;
import io.confluent.catalog.ingestion.EntityIngestor;
import io.confluent.catalog.notification.EntityNotificationListenerV2;
import io.confluent.catalog.notification.MultiTenantKafkaNotification;
import io.confluent.catalog.notification.NotificationEnrichProcessor;
import io.confluent.catalog.notification.NotificationProcessor;
import io.confluent.catalog.notification.NotificationSender;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.discovery.EntityLineageService;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.listener.EntityChangeListener;
import org.apache.atlas.listener.EntityChangeListenerV2;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.repository.audit.EntityAuditListener;
import org.apache.atlas.repository.audit.EntityAuditListenerV2;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.FullTextMapperV2;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.IFullTextMapper;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.graphdb.janus.migration.GraphDBGraphSONMigrator;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.ogm.AtlasAuditEntryDTO;
import org.apache.atlas.repository.ogm.AtlasServerDTO;
import org.apache.atlas.repository.ogm.DTORegistry;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.ogm.DataTransferObject;
import org.apache.atlas.repository.ogm.ExportImportAuditEntryDTO;
import org.apache.atlas.repository.ogm.glossary.AtlasGlossaryCategoryDTO;
import org.apache.atlas.repository.ogm.glossary.AtlasGlossaryDTO;
import org.apache.atlas.repository.ogm.glossary.AtlasGlossaryTermDTO;
import org.apache.atlas.repository.ogm.profiles.AtlasSavedSearchDTO;
import org.apache.atlas.repository.ogm.profiles.AtlasUserProfileDTO;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.BulkImporter;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.repository.store.graph.v2.BulkImporterImpl;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.tasks.ClassificationPropagateTaskFactory;
import org.apache.atlas.service.Service;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.apache.atlas.util.SearchTracker;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCatalogModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(DataCatalogModule.class);
    private final SchemaRegistry schemaRegistry;
    private final DataCatalogConfig dataCatalogConfig;

    public DataCatalogModule(SchemaRegistry schemaRegistry, DataCatalogConfig dataCatalogConfig) {
        this.schemaRegistry = schemaRegistry;
        this.dataCatalogConfig = dataCatalogConfig;
    }

    protected void configure() {
        LOG.info("Configuring catalog module");
        try {
            this.bind(SchemaRegistry.class).toInstance((Object)this.schemaRegistry);
            this.bindAuditRepository(this.binder());
            this.bind(AtlasGraph.class).toInstance((Object)new CfltAtlasJanusGraph(CfltAtlasJanusGraphDatabase.getGraphInstance()));
            this.bind(Configuration.class).toInstance((Object)ApplicationProperties.get());
            this.bind(AtlasTypeDefStore.class).to(CfltAtlasTypeDefGraphStoreV2.class).asEagerSingleton();
            this.bind(AtlasTypeDefGraphStoreV2.class).to(CfltAtlasTypeDefGraphStoreV2.class).asEagerSingleton();
            LOG.debug("configuring type registry");
            this.bind(AtlasTypeRegistry.class).asEagerSingleton();
            LOG.debug("done configuring type registry");
            LOG.debug("configuring entity graph mapper");
            this.bind(EntityGraphMapper.class).asEagerSingleton();
            LOG.debug("done configuring entity graph mapper");
            LOG.debug("configuring export service");
            this.bind(ExportService.class).asEagerSingleton();
            LOG.debug("done configuring export service");
            this.bind(GraphBackedSearchIndexer.class).asEagerSingleton();
            this.bind(EntityGraphRetriever.class).to(CfltEntityGraphRetriever.class);
            Multibinder typeDefChangeListenerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), TypeDefChangeListener.class);
            typeDefChangeListenerMultibinder.addBinding().to(GraphBackedSearchIndexer.class).asEagerSingleton();
            this.bind(SearchTracker.class).asEagerSingleton();
            this.bind(AtlasEntityStore.class).to(CfltAtlasEntityStoreV2.class);
            this.bind(AtlasEntityStoreV2.class).to(CfltAtlasEntityStoreV2.class);
            this.bind(AtlasRelationshipStore.class).to(AtlasRelationshipStoreV2.class);
            this.bind(IAtlasEntityChangeNotifier.class).to(AtlasEntityChangeNotifier.class);
            this.bind(IFullTextMapper.class).to(CfltFullTextMapperV2.class);
            this.bind(FullTextMapperV2.class).to(CfltFullTextMapperV2.class);
            this.bind(AtlasDiscoveryService.class).to(EntityDiscoveryService.class).asEagerSingleton();
            this.bind(AtlasLineageService.class).to(EntityLineageService.class).asEagerSingleton();
            this.bind(BulkImporter.class).to(BulkImporterImpl.class).asEagerSingleton();
            this.bind(GraphDBMigrator.class).to(GraphDBGraphSONMigrator.class).asEagerSingleton();
            Multibinder entityChangeListenerBinder = Multibinder.newSetBinder((Binder)this.binder(), EntityChangeListener.class);
            entityChangeListenerBinder.addBinding().to(EntityAuditListener.class);
            Multibinder entityChangeListenerV2Binder = Multibinder.newSetBinder((Binder)this.binder(), EntityChangeListenerV2.class);
            entityChangeListenerV2Binder.addBinding().to(EntityAuditListenerV2.class);
            if (this.dataCatalogConfig.isCatalogNotificationsEnabled()) {
                this.bind(NotificationInterface.class).annotatedWith(NotificationSender.class).to(MultiTenantKafkaNotification.class).asEagerSingleton();
                this.bind(NotificationInterface.class).annotatedWith(NotificationProcessor.class).to(NotificationEnrichProcessor.class).asEagerSingleton();
                entityChangeListenerV2Binder.addBinding().to(EntityNotificationListenerV2.class);
            }
            Multibinder availableDTOs = Multibinder.newSetBinder((Binder)this.binder(), DataTransferObject.class);
            availableDTOs.addBinding().to(AtlasUserProfileDTO.class);
            availableDTOs.addBinding().to(AtlasSavedSearchDTO.class);
            availableDTOs.addBinding().to(AtlasGlossaryDTO.class);
            availableDTOs.addBinding().to(AtlasGlossaryTermDTO.class);
            availableDTOs.addBinding().to(AtlasGlossaryCategoryDTO.class);
            availableDTOs.addBinding().to(AtlasServerDTO.class);
            availableDTOs.addBinding().to(ExportImportAuditEntryDTO.class);
            availableDTOs.addBinding().to(AtlasAuditEntryDTO.class);
            this.bind(DTORegistry.class).asEagerSingleton();
            this.bind(DataAccess.class).asEagerSingleton();
            this.bind(GlossaryService.class).asEagerSingleton();
            this.bind(TaskManagement.class).asEagerSingleton();
            this.bind(ClassificationPropagateTaskFactory.class).asEagerSingleton();
            this.bind(EntityIngestor.class).asEagerSingleton();
            GraphTransactionInterceptor graphTransactionInterceptor = new GraphTransactionInterceptor(new AtlasGraphProvider().get(), null);
            this.requestInjection(graphTransactionInterceptor);
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(GraphTransaction.class), new MethodInterceptor[]{graphTransactionInterceptor});
        }
        catch (AtlasException e) {
            LOG.error("Error configuring catalog module", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOG.info("Done configuring catalog module");
    }

    protected void bindAuditRepository(Binder binder) {
        Class auditRepoImpl = AtlasRepositoryConfiguration.getAuditRepositoryImpl();
        binder.bind(EntityAuditRepository.class).to(auditRepoImpl).asEagerSingleton();
        if (Service.class.isAssignableFrom(auditRepoImpl)) {
            Class auditRepoService = auditRepoImpl;
            Multibinder serviceBinder = Multibinder.newSetBinder((Binder)binder, Service.class);
            serviceBinder.addBinding().to(auditRepoService);
        }
    }
}

