/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.graph;

import io.confluent.catalog.atlas.repository.store.graph.v2.CfltEntityGraphRetriever;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graph.FullTextMapperV2;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CfltFullTextMapperV2
extends FullTextMapperV2 {
    private static final Logger LOG = LoggerFactory.getLogger(CfltFullTextMapperV2.class);
    private static final String FULL_TEXT_FOLLOW_REFERENCES = "atlas.search.fulltext.followReferences";
    private final Configuration configuration;
    private final EntityGraphRetriever entityGraphRetriever;
    private final boolean followReferences;

    @Inject
    public CfltFullTextMapperV2(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, Configuration configuration) {
        super(atlasGraph, typeRegistry, configuration);
        this.configuration = configuration;
        this.followReferences = this.configuration != null && this.configuration.getBoolean(FULL_TEXT_FOLLOW_REFERENCES, false);
        this.entityGraphRetriever = new CfltEntityGraphRetriever(atlasGraph, typeRegistry, !this.followReferences);
    }

    public AtlasEntity getAndCacheEntity(String guid, boolean includeReferences) throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        AtlasEntity entity = context.getEntity(guid);
        if (entity == null && (entity = this.entityGraphRetriever.toAtlasEntity(guid, includeReferences)) != null) {
            context.cache(entity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss -> GUID = {}", (Object)guid);
            }
        }
        return entity;
    }

    public AtlasEntity.AtlasEntityWithExtInfo getAndCacheEntityWithExtInfo(String guid) throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = context.getEntityWithExtInfo(guid);
        if (entityWithExtInfo == null && (entityWithExtInfo = this.entityGraphRetriever.toAtlasEntityWithExtInfo(guid, !this.followReferences)) != null) {
            context.cache(entityWithExtInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache miss -> GUID = {}", (Object)guid);
            }
        }
        return entityWithExtInfo;
    }
}

