/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.graphdb.janus;

import io.confluent.catalog.atlas.repository.graphdb.janus.CfltAtlasJanusGraphManagement;
import io.confluent.catalog.atlas.repository.graphdb.janus.query.CfltAtlasJanusGraphQuery;
import java.lang.reflect.Field;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsGraph;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfltAtlasJanusGraph
extends AtlasJanusGraph {
    private static final Logger LOG = LoggerFactory.getLogger(CfltAtlasJanusGraph.class);

    public CfltAtlasJanusGraph() {
    }

    public CfltAtlasJanusGraph(JanusGraph graphInstance) {
        super(graphInstance);
    }

    public AtlasGraphQuery<AtlasJanusVertex, AtlasJanusEdge> query() {
        return new CfltAtlasJanusGraphQuery(this);
    }

    public AtlasGraphManagement getManagementSystem() {
        return new CfltAtlasJanusGraphManagement(this, this.getGraph().openManagement());
    }

    public void setVerifyUniqueness(boolean enable) {
        JanusGraphBlueprintsGraph g = (JanusGraphBlueprintsGraph)this.getGraph();
        StandardJanusGraphTx tx = (StandardJanusGraphTx)g.getCurrentThreadTx();
        TransactionConfiguration config = tx.getConfiguration();
        CfltAtlasJanusGraph.setVerifyUniqueness(config, enable);
    }

    private static void setVerifyUniqueness(TransactionConfiguration config, boolean enable) {
        try {
            Class<?> cls = Class.forName("org.janusgraph.graphdb.transaction.StandardTransactionBuilder$ImmutableTxCfg");
            Field field = cls.getDeclaredField("hasVerifyUniqueness");
            field.setAccessible(true);
            field.setBoolean(config, enable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

