/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.graphdb.janus;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.catalog.atlas.repository.graphdb.janus.CfltAtlasJanusGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDatabase;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.serializer.BigDecimalSerializer;
import org.apache.atlas.repository.graphdb.janus.serializer.BigIntegerSerializer;
import org.apache.atlas.repository.graphdb.janus.serializer.TypeCategorySerializer;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.database.serialize.attribute.SerializableSerializer;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfltAtlasJanusGraphDatabase
implements GraphDatabase<AtlasJanusVertex, AtlasJanusEdge> {
    private static final Logger LOG = LoggerFactory.getLogger(CfltAtlasJanusGraphDatabase.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"CfltAtlasJanusGraphDatabase");
    private static final String OLDER_STORAGE_EXCEPTION = "Storage version is incompatible with current client";
    public static final String GRAPH_PREFIX = "atlas.graph";
    public static final String INDEX_BACKEND_CONF = "index.search.backend";
    public static final String SOLR_ZOOKEEPER_URL = "atlas.graph.index.search.solr.zookeeper-url";
    public static final String SOLR_ZOOKEEPER_URLS = "atlas.graph.index.search.solr.zookeeper-urls";
    public static final String INDEX_BACKEND_LUCENE = "lucene";
    public static final String INDEX_BACKEND_ES = "elasticsearch";
    private static volatile CfltAtlasJanusGraph atlasGraphInstance = null;
    private static volatile JanusGraph graphInstance;

    public CfltAtlasJanusGraphDatabase() {
        GraphSONMapper.build().addRegistry((IoRegistry)JanusGraphIoRegistry.getInstance()).create();
    }

    public static Configuration getConfiguration() throws AtlasException {
        Configuration configProperties = ApplicationProperties.get();
        configProperties.setProperty(SOLR_ZOOKEEPER_URLS, (Object)configProperties.getStringArray(SOLR_ZOOKEEPER_URL));
        Configuration janusConfig = ApplicationProperties.getSubsetConfiguration((Configuration)configProperties, (String)GRAPH_PREFIX);
        janusConfig.addProperty("attributes.custom.attribute1.attribute-class", (Object)DataTypes.TypeCategory.class.getName());
        janusConfig.addProperty("attributes.custom.attribute1.serializer-class", (Object)TypeCategorySerializer.class.getName());
        janusConfig.addProperty("attributes.custom.attribute2.attribute-class", (Object)ArrayList.class.getName());
        janusConfig.addProperty("attributes.custom.attribute2.serializer-class", (Object)SerializableSerializer.class.getName());
        janusConfig.addProperty("attributes.custom.attribute3.attribute-class", (Object)BigInteger.class.getName());
        janusConfig.addProperty("attributes.custom.attribute3.serializer-class", (Object)BigIntegerSerializer.class.getName());
        janusConfig.addProperty("attributes.custom.attribute4.attribute-class", (Object)BigDecimal.class.getName());
        janusConfig.addProperty("attributes.custom.attribute4.serializer-class", (Object)BigDecimalSerializer.class.getName());
        return janusConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JanusGraph getGraphInstance() {
        if (graphInstance != null) return graphInstance;
        Class<CfltAtlasJanusGraphDatabase> clazz = CfltAtlasJanusGraphDatabase.class;
        synchronized (CfltAtlasJanusGraphDatabase.class) {
            Configuration config;
            if (graphInstance != null) return graphInstance;
            try {
                config = CfltAtlasJanusGraphDatabase.getConfiguration();
            }
            catch (AtlasException e) {
                throw new RuntimeException(e);
            }
            graphInstance = CfltAtlasJanusGraphDatabase.initJanusGraph(config);
            atlasGraphInstance = new CfltAtlasJanusGraph(graphInstance);
            CfltAtlasJanusGraphDatabase.validateIndexBackend(config);
            // ** MonitorExit[var0] (shouldn't be in output)
            return graphInstance;
        }
    }

    @VisibleForTesting
    static JanusGraph initJanusGraph(Configuration config) {
        org.apache.commons.configuration2.Configuration config2 = CfltAtlasJanusGraphDatabase.config2(config);
        try {
            return JanusGraphFactory.open((org.apache.commons.configuration2.Configuration)config2);
        }
        catch (JanusGraphException e) {
            LOG.warn("JanusGraphException: {}", (Object)e.getMessage());
            if (e.getMessage().startsWith(OLDER_STORAGE_EXCEPTION)) {
                LOG.info("Newer client is being used with older janus storage version. Setting allow-upgrade=true and reattempting connection");
                config.addProperty("graph.allow-upgrade", (Object)true);
                return JanusGraphFactory.open((org.apache.commons.configuration2.Configuration)config2);
            }
            throw new RuntimeException(e);
        }
    }

    public static JanusGraph getBulkLoadingGraphInstance() {
        try {
            Configuration cfg = CfltAtlasJanusGraphDatabase.getConfiguration();
            cfg.setProperty("storage.batch-loading", (Object)true);
            org.apache.commons.configuration2.Configuration cfg2 = CfltAtlasJanusGraphDatabase.config2(cfg);
            return JanusGraphFactory.open((org.apache.commons.configuration2.Configuration)cfg2);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("getBulkLoadingGraphInstance: Failed!", (Throwable)ex);
        }
        catch (AtlasException ex) {
            LOG.error("getBulkLoadingGraphInstance: Failed!", (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        Class<CfltAtlasJanusGraphDatabase> clazz = CfltAtlasJanusGraphDatabase.class;
        synchronized (CfltAtlasJanusGraphDatabase.class) {
            if (graphInstance == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                graphInstance.tx().commit();
                graphInstance.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static org.apache.commons.configuration2.Configuration config2(Configuration config) {
        Properties properties = org.apache.commons.configuration.ConfigurationConverter.getProperties((Configuration)config);
        return ConfigurationConverter.getConfiguration((Properties)properties);
    }

    static void validateIndexBackend(Configuration config) {
        String configuredIndexBackend = config.getString(INDEX_BACKEND_CONF);
        JanusGraphManagement managementSystem = CfltAtlasJanusGraphDatabase.getGraphInstance().openManagement();
        String currentIndexBackend = managementSystem.get(INDEX_BACKEND_CONF);
        managementSystem.commit();
        if (!configuredIndexBackend.equals(currentIndexBackend)) {
            throw new RuntimeException("Configured Index Backend " + configuredIndexBackend + " differs from earlier configured Index Backend " + currentIndexBackend + ". Aborting!");
        }
    }

    public boolean isGraphLoaded() {
        return graphInstance != null;
    }

    public void initializeTestGraph() {
    }

    public void cleanup() {
        JanusGraph g = CfltAtlasJanusGraphDatabase.getGraphInstance();
        try {
            if (g != null) {
                g.close();
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not close test JanusGraph", t);
            t.printStackTrace();
        }
        try {
            if (g != null) {
                JanusGraphFactory.drop((JanusGraph)g);
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not clear test JanusGraph", t);
            t.printStackTrace();
        }
    }

    public AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> getGraph() {
        CfltAtlasJanusGraphDatabase.getGraphInstance();
        return atlasGraphInstance;
    }

    public AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> getGraphBulkLoading() {
        return new AtlasJanusGraph(CfltAtlasJanusGraphDatabase.getBulkLoadingGraphInstance());
    }
}

