/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.store.graph.v2;

import io.confluent.catalog.atlas.repository.store.graph.v2.CfltEntityGraphRetriever;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CfltAtlasEntityStoreV2
extends AtlasEntityStoreV2 {
    private static final Logger LOG = LoggerFactory.getLogger(CfltAtlasEntityStoreV2.class);
    private final AtlasGraph graph;
    private final AtlasTypeRegistry typeRegistry;

    @Inject
    public CfltAtlasEntityStoreV2(AtlasGraph graph, DeleteHandlerDelegate deleteDelegate, AtlasTypeRegistry typeRegistry, IAtlasEntityChangeNotifier entityChangeNotifier, EntityGraphMapper entityGraphMapper) {
        super(graph, deleteDelegate, typeRegistry, entityChangeNotifier, entityGraphMapper);
        this.graph = graph;
        this.typeRegistry = typeRegistry;
    }

    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getById(String guid, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        CfltEntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntityWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getById({}, {})", (Object)guid, (Object)isMinExtInfo);
        }
        if ((ret = (entityRetriever = new CfltEntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).toAtlasEntityWithExtInfo(guid, isMinExtInfo)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(ret.getEntity())), (Object[])new Object[]{"read entity: guid=", guid});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getById({}, {}): {}", new Object[]{guid, isMinExtInfo, ret});
        }
        return ret;
    }

    @GraphTransaction
    public AtlasEntityHeader getHeaderById(String guid) throws AtlasBaseException {
        CfltEntityGraphRetriever entityRetriever;
        AtlasEntityHeader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getHeaderById({})", (Object)guid);
        }
        if ((ret = (entityRetriever = new CfltEntityGraphRetriever(this.graph, this.typeRegistry)).toAtlasEntityHeaderWithClassifications(guid)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, ret), (Object[])new Object[]{"read entity: guid=", guid});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getHeaderById({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getByIds(List<String> guids, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        CfltEntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntitiesWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getByIds({}, {})", guids, (Object)isMinExtInfo);
        }
        if ((ret = (entityRetriever = new CfltEntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).toAtlasEntitiesWithExtInfo(guids, isMinExtInfo)) != null) {
            for (String guid : guids) {
                AtlasEntity entity = ret.getEntity(guid);
                try {
                    AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity: guid=", guid});
                }
                catch (AtlasBaseException e) {
                    if (RequestContext.get().isSkipFailedEntities()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getByIds(): ignoring failure for entity {}: error code={}, message={}", new Object[]{guid, e.getAtlasErrorCode(), e.getMessage()});
                        }
                        ret.removeEntity(guid);
                        ret.removeEntity(entity);
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getByIds({}, {}): {}", new Object[]{guids, isMinExtInfo, ret});
        }
        return ret;
    }

    @GraphTransaction
    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByUniqueAttributes(AtlasEntityType entityType, List<Map<String, Object>> uniqueAttributes, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        CfltEntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntitiesWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntitiesByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqueAttributes);
        }
        if ((ret = (entityRetriever = new CfltEntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).getEntitiesByUniqueAttributes(entityType.getTypeName(), uniqueAttributes, isMinExtInfo)) != null && ret.getEntities() != null) {
            for (AtlasEntity entity : ret.getEntities()) {
                AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", guid=", entity.getGuid()});
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntitiesByUniqueAttributes({}, {}): {}", new Object[]{entityType.getTypeName(), uniqueAttributes, ret});
        }
        return ret;
    }

    @GraphTransaction
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes, boolean isMinExtInfo, boolean ignoreRelationships) throws AtlasBaseException {
        AtlasVertex entityVertex;
        CfltEntityGraphRetriever entityRetriever;
        AtlasEntity.AtlasEntityWithExtInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getByUniqueAttribute({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if ((ret = (entityRetriever = new CfltEntityGraphRetriever(this.graph, this.typeRegistry, ignoreRelationships)).toAtlasEntityWithExtInfo(entityVertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes((AtlasGraph)this.graph, (AtlasEntityType)entityType, uniqAttributes), isMinExtInfo)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), uniqAttributes.toString()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(ret.getEntity())), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getByUniqueAttribute({}, {}): {}", new Object[]{entityType.getTypeName(), uniqAttributes, ret});
        }
        return ret;
    }

    @GraphTransaction
    public AtlasEntityHeader getEntityHeaderByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> uniqAttributes) throws AtlasBaseException {
        AtlasVertex entityVertex;
        CfltEntityGraphRetriever entityRetriever;
        AtlasEntityHeader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getEntityHeaderByUniqueAttributes({}, {})", (Object)entityType.getTypeName(), uniqAttributes);
        }
        if ((ret = (entityRetriever = new CfltEntityGraphRetriever(this.graph, this.typeRegistry)).toAtlasEntityHeader(entityVertex = AtlasGraphUtilsV2.getVertexByUniqueAttributes((AtlasGraph)this.graph, (AtlasEntityType)entityType, uniqAttributes))) == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), uniqAttributes.toString()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_READ, ret), (Object[])new Object[]{"read entity: typeName=", entityType.getTypeName(), ", uniqueAttributes=", uniqAttributes});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getEntityHeaderByUniqueAttributes({}, {}): {}", new Object[]{entityType.getTypeName(), uniqAttributes, ret});
        }
        return ret;
    }
}

