/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.store.graph.v2;

import io.confluent.catalog.atlas.repository.store.graph.v2.CfltAtlasBusinessMetadataDefStoreV2;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.listener.TypeDefChangeListener;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasDefStore;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class CfltAtlasTypeDefGraphStoreV2
extends AtlasTypeDefGraphStoreV2 {
    private static final Logger LOG = LoggerFactory.getLogger(CfltAtlasTypeDefGraphStoreV2.class);
    private EntityDiscoveryService entityDiscoveryService;

    @Inject
    public CfltAtlasTypeDefGraphStoreV2(AtlasTypeRegistry typeRegistry, Set<TypeDefChangeListener> typeDefChangeListeners, AtlasGraph atlasGraph, EntityDiscoveryService entityDiscoveryService) {
        super(typeRegistry, typeDefChangeListeners, atlasGraph, entityDiscoveryService);
        this.entityDiscoveryService = entityDiscoveryService;
    }

    protected AtlasDefStore<AtlasBusinessMetadataDef> getBusinessMetadataDefStore(AtlasTypeRegistry typeRegistry) {
        return new CfltAtlasBusinessMetadataDefStoreV2(this, typeRegistry, this.entityDiscoveryService);
    }

    public AtlasVertex findTypeVertexByNameAndCategory(String typeName, DataTypes.TypeCategory category) {
        Iterator results = this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.TYPENAME_PROPERTY_KEY, (Object)typeName).has(Constants.TYPE_CATEGORY_PROPERTY_KEY, (Object)category).vertices().iterator();
        return results != null && results.hasNext() ? (AtlasVertex)results.next() : null;
    }

    public AtlasVertex findTypeVertexByGuidAndCategory(String typeGuid, DataTypes.TypeCategory category) {
        Iterator vertices = this.atlasGraph.query().has(Constants.VERTEX_TYPE_PROPERTY_KEY, (Object)"typeSystem").has(Constants.GUID_PROPERTY_KEY, (Object)typeGuid).has(Constants.TYPE_CATEGORY_PROPERTY_KEY, (Object)category).vertices().iterator();
        return vertices != null && vertices.hasNext() ? (AtlasVertex)vertices.next() : null;
    }
}

