/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.type.Constants;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CfltEntityGraphRetriever
extends EntityGraphRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(CfltEntityGraphRetriever.class);
    private final GraphHelper graphHelper;
    private final AtlasTypeRegistry typeRegistry;
    private final boolean ignoreRelationshipAttr;

    @Inject
    public CfltEntityGraphRetriever(AtlasGraph graph, AtlasTypeRegistry typeRegistry) {
        super(graph, typeRegistry);
        this.graphHelper = new GraphHelper(graph);
        this.typeRegistry = typeRegistry;
        this.ignoreRelationshipAttr = false;
    }

    public CfltEntityGraphRetriever(AtlasGraph graph, AtlasTypeRegistry typeRegistry, boolean ignoreRelationshipAttr) {
        super(graph, typeRegistry, ignoreRelationshipAttr);
        this.graphHelper = new GraphHelper(graph);
        this.typeRegistry = typeRegistry;
        this.ignoreRelationshipAttr = ignoreRelationshipAttr;
    }

    public Map<String, Map<String, Object>> getBusinessMetadata(AtlasVertex entityVertex) throws AtlasBaseException {
        Map entityTypeBm;
        HashMap<String, HashMap<String, Object>> ret = null;
        String entityTypeName = GraphHelper.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        Map map = entityTypeBm = entityType != null ? entityType.getBusinessAttributes() : null;
        if (MapUtils.isNotEmpty((Map)entityTypeBm)) {
            for (Map.Entry entry : entityTypeBm.entrySet()) {
                String bmName = (String)entry.getKey();
                Map bmAttributes = (Map)entry.getValue();
                HashMap<String, Object> entityBmAttrs = null;
                for (AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute : bmAttributes.values()) {
                    Object bmAttrValue = null;
                    try {
                        bmAttrValue = this.mapVertexToAttribute(entityVertex, (AtlasStructType.AtlasAttribute)bmAttribute, null, false, false);
                    }
                    catch (Exception e) {
                        LOG.warn("Could not load business metadata attr : {}", (Object)bmAttribute.getName());
                    }
                    if (bmAttrValue == null) continue;
                    if (ret == null) {
                        ret = new HashMap<String, HashMap<String, Object>>();
                    }
                    if (entityBmAttrs == null) {
                        entityBmAttrs = new HashMap<String, Object>();
                        ret.put(bmName, entityBmAttrs);
                    }
                    entityBmAttrs.put(bmAttribute.getName(), bmAttrValue);
                }
            }
        }
        return ret;
    }

    private AtlasEntity mapVertexToAtlasEntity(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws AtlasBaseException {
        return this.mapVertexToAtlasEntity(entityVertex, entityExtInfo, false);
    }

    private AtlasEntity mapVertexToAtlasEntity(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        return this.mapVertexToAtlasEntity(entityVertex, entityExtInfo, isMinExtInfo, true);
    }

    private AtlasEntity mapVertexToAtlasEntity(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo, boolean includeReferences) throws AtlasBaseException {
        AtlasEntity entity;
        String guid = GraphHelper.getGuid((AtlasVertex)entityVertex);
        AtlasEntity atlasEntity = entity = entityExtInfo != null ? entityExtInfo.getEntity(guid) : null;
        if (entity == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Mapping graph vertex to atlas entity for guid {}", (Object)guid);
            }
            entity = new AtlasEntity();
            if (entityExtInfo != null) {
                entityExtInfo.addReferredEntity(guid, entity);
            }
            this.mapSystemAttributes(entityVertex, entity);
            this.mapBusinessAttributes(entityVertex, entity);
            this.mapAttributes(entityVertex, (AtlasStruct)entity, entityExtInfo, isMinExtInfo, includeReferences);
            if (!this.ignoreRelationshipAttr) {
                this.mapRelationshipAttributes(entityVertex, entity, entityExtInfo, isMinExtInfo);
            }
            this.mapClassifications(entityVertex, entity);
        }
        return entity;
    }

    private AtlasEntity mapVertexToAtlasEntityMin(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo) throws AtlasBaseException {
        return this.mapVertexToAtlasEntityMin(entityVertex, entityExtInfo, null);
    }

    private AtlasEntity mapVertexToAtlasEntityMin(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, Set<String> attributes) throws AtlasBaseException {
        AtlasEntity entity;
        String guid = GraphHelper.getGuid((AtlasVertex)entityVertex);
        AtlasEntity atlasEntity = entity = entityExtInfo != null ? entityExtInfo.getEntity(guid) : null;
        if (entity == null) {
            entity = new AtlasEntity();
            if (entityExtInfo != null) {
                entityExtInfo.addReferredEntity(guid, entity);
            }
            this.mapSystemAttributes(entityVertex, entity);
            this.mapClassifications(entityVertex, entity);
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
            if (entityType != null) {
                for (AtlasStructType.AtlasAttribute attribute : entityType.getMinInfoAttributes().values()) {
                    Object attrValue = this.getVertexAttribute(entityVertex, attribute);
                    if (attrValue == null) continue;
                    entity.setAttribute(attribute.getName(), attrValue);
                }
            }
        }
        return entity;
    }

    private AtlasEntity mapSystemAttributes(AtlasVertex entityVertex, AtlasEntity entity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping system attributes for type {}", (Object)entity.getTypeName());
        }
        try {
            if (entityVertex != null) {
                entity.setGuid(GraphHelper.getGuid((AtlasVertex)entityVertex));
                entity.setTypeName(GraphHelper.getTypeName((AtlasElement)entityVertex));
                entity.setStatus(GraphHelper.getStatus((AtlasVertex)entityVertex));
                entity.setVersion(GraphHelper.getVersion((AtlasElement)entityVertex));
                entity.setCreatedBy(GraphHelper.getCreatedByAsString((AtlasElement)entityVertex));
                entity.setUpdatedBy(GraphHelper.getModifiedByAsString((AtlasElement)entityVertex));
                entity.setCreateTime(new Date(GraphHelper.getCreatedTime((AtlasElement)entityVertex)));
                entity.setUpdateTime(new Date(GraphHelper.getModifiedTime((AtlasElement)entityVertex)));
                entity.setHomeId(GraphHelper.getHomeId((AtlasElement)entityVertex));
                entity.setIsProxy(GraphHelper.isProxy((AtlasElement)entityVertex));
                entity.setIsIncomplete(GraphHelper.isEntityIncomplete((AtlasElement)entityVertex));
                entity.setProvenanceType(GraphHelper.getProvenanceType((AtlasElement)entityVertex));
                entity.setCustomAttributes(GraphHelper.getCustomAttributes((AtlasElement)entityVertex));
                entity.setLabels(GraphHelper.getLabels((AtlasElement)entityVertex));
                entity.setPendingTasks(this.getPendingTasks(entityVertex));
            }
        }
        catch (Throwable t) {
            LOG.warn("Got exception while mapping system attributes for type {} : ", (Object)entity.getTypeName(), (Object)t);
        }
        return entity;
    }

    private void mapAttributes(AtlasVertex entityVertex, AtlasStruct struct, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        this.mapAttributes(entityVertex, struct, entityExtInfo, isMinExtInfo, true);
    }

    private void mapAttributes(AtlasVertex entityVertex, AtlasStruct struct, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo, boolean includeReferences) throws AtlasBaseException {
        AtlasType objType = this.typeRegistry.getType(struct.getTypeName());
        if (!(objType instanceof AtlasStructType)) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{struct.getTypeName()});
        }
        AtlasStructType structType = (AtlasStructType)objType;
        for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
            Object attrValue = this.mapVertexToAttribute(entityVertex, attribute, entityExtInfo, isMinExtInfo, includeReferences);
            struct.setAttribute(attribute.getName(), attrValue);
        }
    }

    private void mapBusinessAttributes(AtlasVertex entityVertex, AtlasEntity entity) throws AtlasBaseException {
        entity.setBusinessAttributes(this.getBusinessMetadata(entityVertex));
    }

    private void mapClassifications(AtlasVertex entityVertex, AtlasEntity entity) throws AtlasBaseException {
        List edges = GraphHelper.getAllClassificationEdges((AtlasVertex)entityVertex);
        if (CollectionUtils.isNotEmpty((Collection)edges)) {
            ArrayList<AtlasClassification> allClassifications = new ArrayList<AtlasClassification>();
            for (AtlasEdge edge : edges) {
                AtlasVertex classificationVertex = edge.getInVertex();
                AtlasClassification classification = this.toAtlasClassification(classificationVertex);
                if (classification == null) continue;
                allClassifications.add(classification);
            }
            entity.setClassifications(allClassifications);
        }
    }

    private Object mapVertexToAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        return this.mapVertexToAttribute(entityVertex, attribute, entityExtInfo, isMinExtInfo, true);
    }

    private Object mapVertexToAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo, boolean includeReferences) throws AtlasBaseException {
        return this.mapVertexToAttribute(entityVertex, attribute, entityExtInfo, isMinExtInfo, includeReferences, false);
    }

    private Object mapVertexToAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo, boolean includeReferences, boolean ignoreInactive) throws AtlasBaseException {
        Object ret = null;
        AtlasType attrType = attribute.getAttributeType();
        String edgeLabel = attribute.getRelationshipEdgeLabel();
        boolean isOwnedAttribute = attribute.isOwnedRef();
        AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection = attribute.getRelationshipEdgeDirection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping vertex {} to atlas entity {}.{}", new Object[]{entityVertex, attribute.getDefinedInDef().getName(), attribute.getName()});
        }
        switch (attrType.getTypeCategory()) {
            case PRIMITIVE: {
                ret = CfltEntityGraphRetriever.mapVertexToPrimitive((AtlasElement)entityVertex, (String)attribute.getVertexPropertyName(), (AtlasStructDef.AtlasAttributeDef)attribute.getAttributeDef());
                break;
            }
            case ENUM: {
                ret = AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)entityVertex, (String)attribute.getVertexPropertyName(), Object.class);
                break;
            }
            case STRUCT: {
                ret = this.mapVertexToStruct(entityVertex, edgeLabel, null, entityExtInfo, isMinExtInfo);
                break;
            }
            case OBJECT_ID_TYPE: {
                if (includeReferences) {
                    ret = attribute.getAttributeDef().isSoftReferenced() ? this.mapVertexToObjectIdForSoftRef(entityVertex, attribute, entityExtInfo, isMinExtInfo) : this.mapVertexToObjectId(entityVertex, edgeLabel, null, entityExtInfo, isOwnedAttribute, edgeDirection, isMinExtInfo);
                    break;
                }
                ret = null;
                break;
            }
            case ARRAY: {
                AtlasType elementType;
                boolean skipAttribute = !includeReferences ? (elementType = ((AtlasArrayType)attrType).getElementType()) instanceof AtlasBuiltInTypes.AtlasObjectIdType || elementType instanceof AtlasEntityType : false;
                if (skipAttribute) {
                    ret = null;
                    break;
                }
                if (attribute.getAttributeDef().isSoftReferenced()) {
                    ret = this.mapVertexToArrayForSoftRef(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                    break;
                }
                ret = this.mapVertexToArray(entityVertex, entityExtInfo, isOwnedAttribute, attribute, isMinExtInfo, includeReferences, ignoreInactive);
                break;
            }
            case MAP: {
                AtlasType valueType;
                boolean skipAttribute = !includeReferences ? (valueType = ((AtlasMapType)attrType).getValueType()) instanceof AtlasBuiltInTypes.AtlasObjectIdType || valueType instanceof AtlasEntityType : false;
                if (skipAttribute) {
                    ret = null;
                    break;
                }
                if (attribute.getAttributeDef().isSoftReferenced()) {
                    ret = this.mapVertexToMapForSoftRef(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                    break;
                }
                ret = this.mapVertexToMap(entityVertex, entityExtInfo, isOwnedAttribute, attribute, isMinExtInfo, includeReferences);
                break;
            }
        }
        return ret;
    }

    private Map<String, AtlasObjectId> mapVertexToMapForSoftRef(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        HashMap<String, AtlasObjectId> ret = null;
        Map softRefVal = (Map)entityVertex.getProperty(attribute.getVertexPropertyName(), Map.class);
        if (MapUtils.isEmpty((Map)softRefVal)) {
            return softRefVal;
        }
        ret = new HashMap<String, AtlasObjectId>();
        for (Object mapKey : softRefVal.keySet()) {
            AtlasObjectId objectId = this.getAtlasObjectIdFromSoftRefFormat(Objects.toString(softRefVal.get(mapKey)), attribute, entityExtInfo, isMinExtInfo);
            if (objectId == null) continue;
            ret.put(Objects.toString(mapKey), objectId);
        }
        return ret;
    }

    private List<AtlasObjectId> mapVertexToArrayForSoftRef(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        ArrayList<AtlasObjectId> ret = null;
        List softRefVal = entityVertex.getListProperty(attribute.getVertexPropertyName(), List.class);
        if (CollectionUtils.isEmpty((Collection)softRefVal)) {
            return softRefVal;
        }
        ret = new ArrayList<AtlasObjectId>();
        for (Object o : softRefVal) {
            AtlasObjectId objectId = this.getAtlasObjectIdFromSoftRefFormat(Objects.toString(o), attribute, entityExtInfo, isMinExtInfo);
            if (objectId == null) continue;
            ret.add(objectId);
        }
        return ret;
    }

    private AtlasObjectId mapVertexToObjectIdForSoftRef(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        String softRefVal = (String)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)entityVertex, (String)attribute.getVertexPropertyName(), String.class);
        return StringUtils.isNotEmpty((CharSequence)softRefVal) ? this.getAtlasObjectIdFromSoftRefFormat(softRefVal, attribute, entityExtInfo, isMinExtInfo) : null;
    }

    private AtlasObjectId getAtlasObjectIdFromSoftRefFormat(String softRefVal, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) {
        AtlasObjectId ret = AtlasEntityUtil.parseSoftRefValue((String)softRefVal);
        if (ret != null && entityExtInfo != null && attribute.isOwnedRef()) {
            try {
                AtlasEntity entity;
                AtlasVertex referenceVertex = this.getEntityVertex(ret.getGuid());
                if (referenceVertex != null && (entity = isMinExtInfo ? this.mapVertexToAtlasEntityMin(referenceVertex, entityExtInfo) : this.mapVertexToAtlasEntity(referenceVertex, entityExtInfo)) != null) {
                    ret = this.toAtlasObjectId(entity);
                }
            }
            catch (AtlasBaseException excp) {
                LOG.info("failed to retrieve soft-referenced entity(typeName={}, guid={}); errorCode={}. Ignoring", new Object[]{ret.getTypeName(), ret.getGuid(), excp.getAtlasErrorCode()});
            }
        }
        return ret;
    }

    private Map<String, Object> mapVertexToMap(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute attribute, boolean isMinExtInfo, boolean includeReferences) throws AtlasBaseException {
        HashMap<String, Object> ret = null;
        AtlasMapType mapType = (AtlasMapType)attribute.getAttributeType();
        AtlasType mapValueType = mapType.getValueType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping map attribute {} for vertex {}", (Object)mapType.getTypeName(), (Object)entityVertex);
        }
        if (AtlasGraphUtilsV2.isReference((AtlasType)mapValueType)) {
            Map currentMap = GraphHelper.getReferenceMap((AtlasVertex)entityVertex, (AtlasStructType.AtlasAttribute)attribute);
            if (MapUtils.isNotEmpty((Map)currentMap)) {
                ret = new HashMap<String, Object>();
                for (Map.Entry entry : currentMap.entrySet()) {
                    String mapKey = (String)entry.getKey();
                    Object keyValue = entry.getValue();
                    Object mapValue = this.mapVertexToCollectionEntry(entityVertex, mapValueType, keyValue, attribute.getRelationshipEdgeLabel(), entityExtInfo, isOwnedAttribute, attribute.getRelationshipEdgeDirection(), isMinExtInfo, includeReferences);
                    if (mapValue == null) continue;
                    ret.put(mapKey, mapValue);
                }
            }
        } else {
            ret = GraphHelper.getPrimitiveMap((AtlasVertex)entityVertex, (String)attribute.getVertexPropertyName());
        }
        return ret;
    }

    private List<Object> mapVertexToArray(AtlasVertex entityVertex, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute attribute, boolean isMinExtInfo, boolean includeReferences, boolean ignoreInactive) throws AtlasBaseException {
        AtlasArrayType arrayType = (AtlasArrayType)attribute.getAttributeType();
        AtlasType arrayElementType = arrayType.getElementType();
        List arrayElements = GraphHelper.getArrayElementsProperty((AtlasType)arrayElementType, (AtlasVertex)entityVertex, (AtlasStructType.AtlasAttribute)attribute);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping array attribute {} for vertex {}", (Object)arrayElementType.getTypeName(), (Object)entityVertex);
        }
        if (CollectionUtils.isEmpty((Collection)arrayElements)) {
            return arrayElements;
        }
        ArrayList<Object> arrValues = new ArrayList<Object>(arrayElements.size());
        String edgeLabel = attribute.getRelationshipEdgeLabel();
        AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection = attribute.getRelationshipEdgeDirection();
        for (Object element : arrayElements) {
            Object arrValue;
            if (element == null) {
                LOG.debug("Skipping null arrayElement");
                continue;
            }
            if (this.isInactiveEdge(element, ignoreInactive) || (arrValue = this.mapVertexToCollectionEntry(entityVertex, arrayElementType, element, edgeLabel, entityExtInfo, isOwnedAttribute, edgeDirection, isMinExtInfo, includeReferences)) == null) continue;
            arrValues.add(arrValue);
        }
        return arrValues;
    }

    private Object mapVertexToCollectionEntry(AtlasVertex entityVertex, AtlasType arrayElement, Object value, String edgeLabel, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection, boolean isMinExtInfo, boolean includeReferences) throws AtlasBaseException {
        Object ret = null;
        switch (arrayElement.getTypeCategory()) {
            case PRIMITIVE: 
            case ENUM: 
            case ARRAY: 
            case MAP: {
                ret = value;
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            case STRUCT: {
                ret = this.mapVertexToStruct(entityVertex, edgeLabel, (AtlasEdge)value, entityExtInfo, isMinExtInfo);
                break;
            }
            case OBJECT_ID_TYPE: {
                ret = includeReferences ? this.mapVertexToObjectId(entityVertex, edgeLabel, (AtlasEdge)value, entityExtInfo, isOwnedAttribute, edgeDirection, isMinExtInfo) : null;
                break;
            }
        }
        return ret;
    }

    private AtlasObjectId mapVertexToObjectId(AtlasVertex entityVertex, String edgeLabel, AtlasEdge edge, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isOwnedAttribute, AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection edgeDirection, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasObjectId ret = null;
        if (edge == null) {
            edge = this.graphHelper.getEdgeForLabel(entityVertex, edgeLabel, edgeDirection);
        }
        if (GraphHelper.elementExists((AtlasElement)edge)) {
            AtlasVertex referenceVertex = edge.getInVertex();
            if (StringUtils.equals((CharSequence)AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)referenceVertex), (CharSequence)AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)entityVertex))) {
                referenceVertex = edge.getOutVertex();
            }
            if (referenceVertex != null) {
                if (entityExtInfo != null && isOwnedAttribute) {
                    AtlasEntity entity = isMinExtInfo ? this.mapVertexToAtlasEntityMin(referenceVertex, entityExtInfo) : this.mapVertexToAtlasEntity(referenceVertex, entityExtInfo);
                    if (entity != null) {
                        ret = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity);
                    }
                } else {
                    ret = this.toAtlasObjectId(referenceVertex);
                }
            }
        }
        return ret;
    }

    private AtlasStruct mapVertexToStruct(AtlasVertex entityVertex, String edgeLabel, AtlasEdge edge, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasStruct ret = null;
        if (edge == null) {
            edge = this.graphHelper.getEdgeForLabel(entityVertex, edgeLabel);
        }
        if (GraphHelper.elementExists((AtlasElement)edge)) {
            AtlasVertex referenceVertex = edge.getInVertex();
            ret = new AtlasStruct(GraphHelper.getTypeName((AtlasElement)referenceVertex));
            this.mapAttributes(referenceVertex, ret, entityExtInfo, isMinExtInfo);
        }
        return ret;
    }

    private Object getVertexAttribute(AtlasVertex vertex, AtlasStructType.AtlasAttribute attribute) throws AtlasBaseException {
        return vertex != null && attribute != null ? this.mapVertexToAttribute(vertex, attribute, null, false) : null;
    }

    private void mapRelationshipAttributes(AtlasVertex entityVertex, AtlasEntity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{entity.getTypeName()});
        }
        for (String attributeName : entityType.getRelationshipAttributes().keySet()) {
            this.mapVertexToRelationshipAttribute(entityVertex, entityType, attributeName, entity, entityExtInfo, isMinExtInfo);
        }
    }

    private Object mapVertexToRelationshipAttribute(AtlasVertex entityVertex, AtlasEntityType entityType, String attributeName, AtlasEntity entity, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasRelationshipType relationshipType;
        Object ret = null;
        String relationshipTypeName = this.graphHelper.getRelationshipTypeName(entityVertex, entityType, attributeName);
        AtlasRelationshipType atlasRelationshipType = relationshipType = relationshipTypeName != null ? this.typeRegistry.getRelationshipTypeByName(relationshipTypeName) : null;
        if (relationshipType == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID, new String[]{"relationshipDef is null"});
        }
        AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attributeName, relationshipTypeName);
        AtlasRelationshipDef relationshipDef = relationshipType.getRelationshipDef();
        AtlasRelationshipEndDef endDef1 = relationshipDef.getEndDef1();
        AtlasRelationshipEndDef endDef2 = relationshipDef.getEndDef2();
        AtlasEntityType endDef1Type = this.typeRegistry.getEntityTypeByName(endDef1.getType());
        AtlasEntityType endDef2Type = this.typeRegistry.getEntityTypeByName(endDef2.getType());
        AtlasRelationshipEndDef attributeEndDef = null;
        if (endDef1Type.isTypeOrSuperTypeOf(entityType.getTypeName()) && StringUtils.equals((CharSequence)endDef1.getName(), (CharSequence)attributeName)) {
            attributeEndDef = endDef1;
        } else if (endDef2Type.isTypeOrSuperTypeOf(entityType.getTypeName()) && StringUtils.equals((CharSequence)endDef2.getName(), (CharSequence)attributeName)) {
            attributeEndDef = endDef2;
        }
        if (attributeEndDef == null) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID, new String[]{relationshipDef.toString()});
        }
        switch (attributeEndDef.getCardinality()) {
            case SINGLE: {
                ret = this.mapRelatedVertexToObjectId(entityVertex, attribute, entityExtInfo, isMinExtInfo);
                break;
            }
            case LIST: 
            case SET: {
                ret = this.mapRelationshipArrayAttribute(entityVertex, attribute, entityExtInfo, isMinExtInfo);
            }
        }
        entity.setRelationshipAttribute(attributeName, ret);
        if (attributeEndDef.getIsLegacyAttribute() && !entity.hasAttribute(attributeName)) {
            entity.setAttribute(attributeName, this.toLegacyAttribute(ret));
        }
        return ret;
    }

    private Object toLegacyAttribute(Object obj) {
        Object ret = obj instanceof AtlasRelatedObjectId ? this.toLegacyAttribute((AtlasRelatedObjectId)obj) : (obj instanceof Collection ? this.toLegacyAttribute((Collection)obj) : (obj instanceof Map ? this.toLegacyAttribute((Map)obj) : obj));
        return ret;
    }

    private AtlasObjectId toLegacyAttribute(AtlasRelatedObjectId relatedObjId) {
        Object ret = relatedObjId.getRelationshipStatus() == AtlasRelationship.Status.DELETED && relatedObjId.getEntityStatus() == AtlasEntity.Status.ACTIVE ? null : new AtlasObjectId((AtlasObjectId)relatedObjId);
        return ret;
    }

    private Collection toLegacyAttribute(Collection collection) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object elem : collection) {
            Object objId = this.toLegacyAttribute(elem);
            if (objId == null) continue;
            ret.add(objId);
        }
        return ret;
    }

    private Map toLegacyAttribute(Map map) {
        HashMap ret = new HashMap();
        for (Object key : map.keySet()) {
            Object elem = this.toLegacyAttribute(map.get(key));
            if (elem == null) continue;
            ret.put(key, elem);
        }
        return ret;
    }

    private AtlasObjectId mapRelatedVertexToObjectId(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasEdge edge = this.graphHelper.getEdgeForLabel(entityVertex, attribute.getRelationshipEdgeLabel(), attribute.getRelationshipEdgeDirection());
        return this.mapVertexToRelatedObjectId(entityVertex, edge, attribute.isOwnedRef(), entityExtInfo, isMinExtInfo);
    }

    private List<AtlasRelatedObjectId> mapRelationshipArrayAttribute(AtlasVertex entityVertex, AtlasStructType.AtlasAttribute attribute, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        ArrayList<AtlasRelatedObjectId> ret = new ArrayList<AtlasRelatedObjectId>();
        Iterator edges = null;
        if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN) {
            edges = GraphHelper.getIncomingEdgesByLabel((AtlasVertex)entityVertex, (String)attribute.getRelationshipEdgeLabel());
        } else if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT) {
            edges = GraphHelper.getOutGoingEdgesByLabel((AtlasVertex)entityVertex, (String)attribute.getRelationshipEdgeLabel());
        } else if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.BOTH) {
            edges = GraphHelper.getAdjacentEdgesByLabel((AtlasVertex)entityVertex, (AtlasEdgeDirection)AtlasEdgeDirection.BOTH, (String)attribute.getRelationshipEdgeLabel());
        }
        if (edges != null) {
            while (edges.hasNext()) {
                AtlasEdge relationshipEdge = (AtlasEdge)edges.next();
                AtlasRelatedObjectId relatedObjectId = this.mapVertexToRelatedObjectId(entityVertex, relationshipEdge, attribute.isOwnedRef(), entityExtInfo, isMinExtInfo);
                ret.add(relatedObjectId);
            }
        }
        return ret;
    }

    private AtlasRelatedObjectId mapVertexToRelatedObjectId(AtlasVertex entityVertex, AtlasEdge edge, boolean isOwnedRef, AtlasEntity.AtlasEntityExtInfo entityExtInfo, boolean isMinExtInfo) throws AtlasBaseException {
        AtlasRelatedObjectId ret = null;
        if (GraphHelper.elementExists((AtlasElement)edge)) {
            AtlasVertex referenceVertex = edge.getInVertex();
            if (StringUtils.equals((CharSequence)AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)referenceVertex), (CharSequence)AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)entityVertex))) {
                referenceVertex = edge.getOutVertex();
            }
            if (referenceVertex != null) {
                String entityTypeName = GraphHelper.getTypeName((AtlasElement)referenceVertex);
                String entityGuid = GraphHelper.getGuid((AtlasVertex)referenceVertex);
                AtlasEntity.Status entityStatus = GraphHelper.getStatus((AtlasVertex)referenceVertex);
                AtlasRelationship relationship = this.mapEdgeToAtlasRelationship(edge);
                ret = new AtlasRelatedObjectId(entityGuid, entityTypeName, entityStatus, relationship.getGuid(), relationship.getStatus(), new AtlasStruct(relationship.getTypeName(), relationship.getAttributes()));
                Object displayText = this.getDisplayText(referenceVertex, entityTypeName);
                if (displayText != null) {
                    ret.setDisplayText(displayText.toString());
                }
                if (isOwnedRef && entityExtInfo != null) {
                    if (isMinExtInfo) {
                        this.mapVertexToAtlasEntityMin(referenceVertex, entityExtInfo);
                    } else {
                        this.mapVertexToAtlasEntity(referenceVertex, entityExtInfo);
                    }
                }
            }
        }
        return ret;
    }

    private Object getDisplayText(AtlasVertex entityVertex, String entityTypeName) throws AtlasBaseException {
        return this.getDisplayText(entityVertex, this.typeRegistry.getEntityTypeByName(entityTypeName));
    }

    private Object getDisplayText(AtlasVertex entityVertex, AtlasEntityType entityType) throws AtlasBaseException {
        Object ret = null;
        if (entityType != null) {
            String displayTextAttribute = entityType.getDisplayTextAttribute();
            if (displayTextAttribute != null) {
                ret = this.getVertexAttribute(entityVertex, entityType.getAttribute(displayTextAttribute));
            }
            if (ret == null && (ret = this.getVertexAttribute(entityVertex, entityType.getAttribute("name"))) == null && (ret = this.getVertexAttribute(entityVertex, entityType.getAttribute("displayName"))) == null) {
                ret = this.getVertexAttribute(entityVertex, entityType.getAttribute("qualifiedName"));
            }
        }
        return ret;
    }

    private Set<String> getPendingTasks(AtlasVertex entityVertex) {
        Collection ret = entityVertex.getPropertyValues(Constants.PENDING_TASKS_PROPERTY_KEY, String.class);
        if (CollectionUtils.isEmpty((Collection)ret)) {
            return null;
        }
        return new HashSet<String>(ret);
    }

    private boolean isInactiveEdge(Object element, boolean ignoreInactive) {
        return ignoreInactive && element instanceof AtlasEdge && GraphHelper.getStatus((AtlasEdge)((AtlasEdge)element)) != AtlasEntity.Status.ACTIVE;
    }
}

