/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.client.autthorizer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;

public interface CatalogAuthorizerClient {
    public static final String API_METHOD_NAME_HEADER = "CATALOG_API_METHOD_NAME_HEADER";
    public static final String CLIENT_IP = "CATALOG_CLIENT_IP";
    public static final String PORT_NUMBER = "CATALOG_PORT_NUMBER";

    public void init(SchemaRegistry var1);

    public List<CatalogAuthorizerResponse> authorize(ContainerRequestContext var1, String var2, CatalogAuthorizerRequest var3) throws CatalogAuthorizerRestClientException;

    public static class CatalogAuthorizerRestClientException
    extends IOException {
        public CatalogAuthorizerRestClientException(String message) {
            super(message);
        }
    }

    public static class CatalogAuthorizerResponse {
        private final CatalogAuthorizeResult result;
        private final String resourceName;
        private final String operation;

        @JsonCreator
        public CatalogAuthorizerResponse(@JsonProperty(value="result") CatalogAuthorizeResult result, @JsonProperty(value="resource_name") String resourceName, @JsonProperty(value="operation") String operation) {
            this.result = result;
            this.resourceName = resourceName;
            this.operation = operation;
        }

        public CatalogAuthorizeResult getResult() {
            return this.result;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    public static class CatalogAuthorizerRequest {
        private final String principal;
        private final List<CatalogAuthorizerAction> actions;

        public CatalogAuthorizerRequest(String principal, List<CatalogAuthorizerAction> actions) {
            this.principal = principal;
            this.actions = actions;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public List<CatalogAuthorizerAction> getActions() {
            return this.actions;
        }
    }

    public static class CatalogAuthorizerAction {
        private final String resourceName;
        private final String operation;
        private final String resourceType;

        public CatalogAuthorizerAction(String resourceName, String operation, String resourceType) {
            this.resourceName = resourceName;
            this.operation = operation;
            this.resourceType = resourceType;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getResourceType() {
            return this.resourceType;
        }
    }

    public static enum CatalogAuthorizeResult {
        ALLOWED,
        DENIED,
        UNKNOWN_SCOPE,
        AUTHORIZER_FAILED,
        UNKNOWN_ERROR;

    }
}

