/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.client.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.catalog.model.instance.BusinessMetadata;
import io.confluent.catalog.model.instance.SchemaMetadata;
import io.confluent.catalog.model.instance.Tag;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.web.rest.entities.BusinessMetadataDefResponse;
import io.confluent.catalog.web.rest.entities.BusinessMetadataResponse;
import io.confluent.catalog.web.rest.entities.SchemaTagsResponse;
import io.confluent.catalog.web.rest.entities.SearchResult;
import io.confluent.catalog.web.rest.entities.TagDefResponse;
import io.confluent.catalog.web.rest.entities.TagResponse;
import io.confluent.catalog.web.rest.entities.TimeRangeType;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.rest.exceptions.RestException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.atlas.SortOrder;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.kafka.common.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogRestService
extends RestService
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogRestService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Boolean> BOOLEAN_TYPE = new TypeReference<Boolean>(){};
    private static final TypeReference<SearchResult> SEARCH_RESULT_TYPE = new TypeReference<SearchResult>(){};
    private static final TypeReference<AtlasEntity.AtlasEntityWithExtInfo> ENTITY_TYPE = new TypeReference<AtlasEntity.AtlasEntityWithExtInfo>(){};
    private static final TypeReference<EntityMutationResponse> ENTITY_MUTATION_RESPONSE_TYPE = new TypeReference<EntityMutationResponse>(){};
    private static final TypeReference<List<TagDefResponse>> TAG_DEFS_TYPE = new TypeReference<List<TagDefResponse>>(){};
    private static final TypeReference<TagDef> TAG_DEF_TYPE = new TypeReference<TagDef>(){};
    private static final TypeReference<List<BusinessMetadataDefResponse>> BM_DEFS_TYPE = new TypeReference<List<BusinessMetadataDefResponse>>(){};
    private static final TypeReference<AtlasBusinessMetadataDef> BM_DEF_TYPE = new TypeReference<AtlasBusinessMetadataDef>(){};
    private static final TypeReference<List<BusinessMetadataResponse>> BMS_TYPE = new TypeReference<List<BusinessMetadataResponse>>(){};
    private static final TypeReference<List<SchemaTagsResponse>> SCHEMA_TAGS_TYPE = new TypeReference<List<SchemaTagsResponse>>(){};
    private static final TypeReference<String> STRING_TYPE = new TypeReference<String>(){};
    private static final TypeReference<List<TagResponse>> TAGS_TYPE = new TypeReference<List<TagResponse>>(){};
    private static final TypeReference<Void> VOID_TYPE = new TypeReference<Void>(){};
    private static final TypeReference<JsonNode> JSON_NODE_TYPE = new TypeReference<JsonNode>(){};

    public CatalogRestService(UrlList baseUrls) {
        super(baseUrls);
    }

    public CatalogRestService(List<String> baseUrls) {
        super(baseUrls);
    }

    public CatalogRestService(String baseUrlConfig) {
        super(baseUrlConfig);
    }

    public boolean ready() throws IOException, RestClientException {
        return this.ready(DEFAULT_REQUEST_PROPERTIES);
    }

    public boolean ready(Map<String, String> requestProperties) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/ready");
        String path = builder.build(new Object[0]).toString();
        return (Boolean)this.httpRequest(path, "GET", null, requestProperties, BOOLEAN_TYPE);
    }

    public boolean synced() throws IOException, RestClientException {
        return this.synced(DEFAULT_REQUEST_PROPERTIES);
    }

    public boolean synced(Map<String, String> requestProperties) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/synced");
        String path = builder.build(new Object[0]).toString();
        return (Boolean)this.httpRequest(path, "GET", null, requestProperties, BOOLEAN_TYPE);
    }

    public SearchResult searchBasic(String query, String type, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchBasic(query, Collections.singletonList(type), includeDeleted, limit, offset);
    }

    public SearchResult searchBasic(String query, List<String> types, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchBasic((Map<String, String>)DEFAULT_REQUEST_PROPERTIES, query, types, includeDeleted, limit, offset);
    }

    public SearchResult searchBasic(Map<String, String> requestProperties, String query, String type, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchBasic(requestProperties, query, Collections.singletonList(type), includeDeleted, limit, offset);
    }

    public SearchResult searchBasic(Map<String, String> requestProperties, String query, List<String> types, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchBasic(requestProperties, query, types, null, null, includeDeleted, limit, offset);
    }

    public SearchResult searchBasic(Map<String, String> requestProperties, String query, List<String> types, List<String> attrs, List<String> tags, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchBasic(requestProperties, query, types, attrs, tags, null, null, 0L, 0L, includeDeleted, limit, offset);
    }

    public SearchResult searchBasic(Map<String, String> requestProperties, String query, List<String> types, List<String> attrs, List<String> tags, TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchBasic(requestProperties, query, types, attrs, tags, timeRangeType, timeRangeAttr, timeRangeStart, timeRangeEnd, null, null, includeDeleted, limit, offset);
    }

    public SearchResult searchBasic(Map<String, String> requestProperties, String query, List<String> types, List<String> attrs, List<String> tags, TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd, String sortBy, SortOrder sortOrder, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/search/basic").queryParam("query", new Object[]{query}).queryParam("type", types.toArray()).queryParam("deleted", new Object[]{includeDeleted}).queryParam("limit", new Object[]{limit}).queryParam("offset", new Object[]{offset});
        if (attrs != null) {
            builder = builder.queryParam("attr", attrs.toArray());
        }
        if (tags != null) {
            builder = builder.queryParam("tag", tags.toArray());
        }
        if (timeRangeAttr != null) {
            builder = builder.queryParam("timeRangeAttr", new Object[]{timeRangeAttr});
            if (timeRangeType != null) {
                builder = builder.queryParam("timeRangeType", new Object[]{timeRangeType.name()});
            }
            if (timeRangeType == null || timeRangeType == TimeRangeType.CUSTOM) {
                builder = builder.queryParam("timeRangeStart", new Object[]{timeRangeStart}).queryParam("timeRangeEnd", new Object[]{timeRangeEnd});
            }
        }
        if (sortBy != null) {
            builder = builder.queryParam("sortBy", new Object[]{sortBy});
        }
        if (sortOrder != null) {
            builder = builder.queryParam("sortOrder", new Object[]{sortOrder});
        }
        String path = builder.build(new Object[0]).toString();
        return (SearchResult)this.httpRequest(path, "GET", null, requestProperties, SEARCH_RESULT_TYPE);
    }

    public SearchResult searchAttribute(String type, String attrName, String attrValuePrefix, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchAttribute(Collections.singletonList(type), attrName, attrValuePrefix, includeDeleted, limit, offset);
    }

    public SearchResult searchAttribute(List<String> types, String attrName, String attrValuePrefix, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchAttribute((Map<String, String>)DEFAULT_REQUEST_PROPERTIES, types, attrName, attrValuePrefix, includeDeleted, limit, offset);
    }

    public SearchResult searchAttribute(Map<String, String> requestProperties, String type, String attrName, String attrValuePrefix, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchAttribute(requestProperties, Collections.singletonList(type), attrName, attrValuePrefix, includeDeleted, limit, offset);
    }

    public SearchResult searchAttribute(Map<String, String> requestProperties, List<String> types, String attrName, String attrValuePrefix, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchAttribute(requestProperties, types, null, attrName, attrValuePrefix, null, includeDeleted, limit, offset);
    }

    public SearchResult searchAttribute(Map<String, String> requestProperties, List<String> types, List<String> attrs, String attrName, String attrValuePrefix, List<String> tags, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchAttribute(requestProperties, types, attrs, attrName, attrValuePrefix, tags, null, null, 0L, 0L, includeDeleted, limit, offset);
    }

    public SearchResult searchAttribute(Map<String, String> requestProperties, List<String> types, List<String> attrs, String attrName, String attrValuePrefix, List<String> tags, TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        return this.searchAttribute(requestProperties, types, attrs, attrName, attrValuePrefix, tags, timeRangeType, timeRangeAttr, timeRangeStart, timeRangeEnd, null, null, includeDeleted, limit, offset);
    }

    public SearchResult searchAttribute(Map<String, String> requestProperties, List<String> types, List<String> attrs, String attrName, String attrValuePrefix, List<String> tags, TimeRangeType timeRangeType, String timeRangeAttr, long timeRangeStart, long timeRangeEnd, String sortBy, SortOrder sortOrder, boolean includeDeleted, int limit, int offset) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/search/attribute").queryParam("type", types.toArray()).queryParam("attrName", new Object[]{attrName}).queryParam("attrValuePrefix", new Object[]{attrValuePrefix}).queryParam("deleted", new Object[]{includeDeleted}).queryParam("limit", new Object[]{limit}).queryParam("offset", new Object[]{offset});
        if (attrs != null) {
            builder = builder.queryParam("attr", attrs.toArray());
        }
        if (tags != null) {
            builder = builder.queryParam("tag", tags.toArray());
        }
        if (timeRangeAttr != null) {
            builder = builder.queryParam("timeRangeAttr", new Object[]{timeRangeAttr});
            if (timeRangeType != null) {
                builder = builder.queryParam("timeRangeType", new Object[]{timeRangeType.name()});
            }
            if (timeRangeType == null || timeRangeType == TimeRangeType.CUSTOM) {
                builder = builder.queryParam("timeRangeStart", new Object[]{timeRangeStart}).queryParam("timeRangeEnd", new Object[]{timeRangeEnd});
            }
        }
        if (sortBy != null) {
            builder = builder.queryParam("sortBy", new Object[]{sortBy});
        }
        if (sortOrder != null) {
            builder = builder.queryParam("sortOrder", new Object[]{sortOrder});
        }
        String path = builder.build(new Object[0]).toString();
        return (SearchResult)this.httpRequest(path, "GET", null, requestProperties, SEARCH_RESULT_TYPE);
    }

    public EntityMutationResponse createOrUpdateEntity(AtlasEntity.AtlasEntityWithExtInfo entity) throws IOException, RestClientException {
        return this.createOrUpdateEntity(DEFAULT_REQUEST_PROPERTIES, entity);
    }

    public EntityMutationResponse createOrUpdateEntity(Map<String, String> requestProperties, AtlasEntity.AtlasEntityWithExtInfo entity) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes((Object)entity);
        return (EntityMutationResponse)this.httpRequest(path, "POST", payload, requestProperties, ENTITY_MUTATION_RESPONSE_TYPE);
    }

    public EntityMutationResponse partiallyUpdateEntity(AtlasEntity.AtlasEntityWithExtInfo entity) throws IOException, RestClientException {
        return this.partiallyUpdateEntity(DEFAULT_REQUEST_PROPERTIES, entity);
    }

    public EntityMutationResponse partiallyUpdateEntity(Map<String, String> requestProperties, AtlasEntity.AtlasEntityWithExtInfo entity) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes((Object)entity);
        return (EntityMutationResponse)this.httpRequest(path, "PUT", payload, requestProperties, ENTITY_MUTATION_RESPONSE_TYPE);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntity(String typeName, String qualifiedName, boolean minExtInfo, boolean ignoreRelationships) throws IOException, RestClientException {
        return this.getEntity(DEFAULT_REQUEST_PROPERTIES, typeName, qualifiedName, minExtInfo, ignoreRelationships, null);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntity(Map<String, String> requestProperties, String typeName, String qualifiedName, boolean minExtInfo, boolean ignoreRelationships) throws RestClientException, IOException {
        return this.getEntity(requestProperties, typeName, qualifiedName, minExtInfo, ignoreRelationships, null);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntity(Map<String, String> requestProperties, String typeName, String qualifiedName, boolean minExtInfo, boolean ignoreRelationships, String includeInternalPrefix) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}").queryParam("minExtInfo", new Object[]{minExtInfo}).queryParam("ignoreRelationships", new Object[]{ignoreRelationships});
        if (includeInternalPrefix != null) {
            builder.queryParam("includeInternalPrefix", new Object[]{includeInternalPrefix});
        }
        String path = builder.build(new Object[]{typeName, qualifiedName}).toString();
        return (AtlasEntity.AtlasEntityWithExtInfo)this.httpRequest(path, "GET", null, requestProperties, ENTITY_TYPE);
    }

    public void deleteEntity(String typeName, String qualifiedName) throws IOException, RestClientException {
        this.deleteEntity(DEFAULT_REQUEST_PROPERTIES, typeName, qualifiedName, false);
    }

    public void deleteEntity(Map<String, String> requestProperties, String typeName, String qualifiedName, boolean purge) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}").queryParam("purge", new Object[]{purge});
        String path = builder.build(new Object[]{typeName, qualifiedName}).toString();
        this.httpRequest(path, "DELETE", null, requestProperties, VOID_TYPE);
    }

    public List<TagDefResponse> createTagDefs(List<TagDef> tagDefs) throws IOException, RestClientException {
        return this.createTagDefs(DEFAULT_REQUEST_PROPERTIES, tagDefs);
    }

    public List<TagDefResponse> createTagDefs(Map<String, String> requestProperties, List<TagDef> tagDefs) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(tagDefs);
        return (List)this.httpRequest(path, "POST", payload, requestProperties, TAG_DEFS_TYPE);
    }

    public List<TagDefResponse> getTagDefs(String prefix, String substring) throws IOException, RestClientException {
        return this.getTagDefs(DEFAULT_REQUEST_PROPERTIES, prefix, substring);
    }

    public List<TagDefResponse> getTagDefs(Map<String, String> requestProperties, String prefix, String substring) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs").queryParam("prefix", new Object[]{prefix}).queryParam("substring", new Object[]{substring});
        String path = builder.build(new Object[0]).toString();
        return (List)this.httpRequest(path, "GET", null, requestProperties, TAG_DEFS_TYPE);
    }

    public TagDef getTagDef(String tagName) throws IOException, RestClientException {
        return this.getTagDef(DEFAULT_REQUEST_PROPERTIES, tagName);
    }

    public TagDef getTagDef(Map<String, String> requestProperties, String tagName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs/{tagName}");
        String path = builder.build(new Object[]{tagName}).toString();
        return (TagDef)((Object)this.httpRequest(path, "GET", null, requestProperties, TAG_DEF_TYPE));
    }

    public List<TagDefResponse> updateTagDefs(List<TagDef> tagDefs) throws IOException, RestClientException {
        return this.updateTagDefs(DEFAULT_REQUEST_PROPERTIES, tagDefs);
    }

    public List<TagDefResponse> updateTagDefs(Map<String, String> requestProperties, List<TagDef> tagDefs) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(tagDefs);
        return (List)this.httpRequest(path, "PUT", payload, requestProperties, TAG_DEFS_TYPE);
    }

    public String deleteTagDef(String tagName) throws IOException, RestClientException {
        return this.deleteTagDef(DEFAULT_REQUEST_PROPERTIES, tagName);
    }

    public String deleteTagDef(Map<String, String> requestProperties, String tagName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/tagdefs/{tagName}");
        String path = builder.build(new Object[]{tagName}).toString();
        return (String)this.httpRequest(path, "DELETE", null, requestProperties, STRING_TYPE);
    }

    public List<BusinessMetadataDefResponse> createBMDefs(List<AtlasBusinessMetadataDef> bmDefs) throws IOException, RestClientException {
        return this.createBMDefs(DEFAULT_REQUEST_PROPERTIES, bmDefs);
    }

    public List<BusinessMetadataDefResponse> createBMDefs(Map<String, String> requestProperties, List<AtlasBusinessMetadataDef> bmDefs) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(bmDefs);
        return (List)this.httpRequest(path, "POST", payload, requestProperties, BM_DEFS_TYPE);
    }

    public List<BusinessMetadataDefResponse> getBMDefs(String prefix) throws IOException, RestClientException {
        return this.getBMDefs(DEFAULT_REQUEST_PROPERTIES, prefix);
    }

    public List<BusinessMetadataDefResponse> getBMDefs(Map<String, String> requestProperties, String prefix) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs").queryParam("prefix", new Object[]{prefix});
        String path = builder.build(new Object[0]).toString();
        return (List)this.httpRequest(path, "GET", null, requestProperties, BM_DEFS_TYPE);
    }

    public AtlasBusinessMetadataDef getBMDef(String bmName) throws IOException, RestClientException {
        return this.getBMDef(DEFAULT_REQUEST_PROPERTIES, bmName);
    }

    public AtlasBusinessMetadataDef getBMDef(Map<String, String> requestProperties, String bmName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs/{bmName}");
        String path = builder.build(new Object[]{bmName}).toString();
        return (AtlasBusinessMetadataDef)this.httpRequest(path, "GET", null, requestProperties, BM_DEF_TYPE);
    }

    public List<BusinessMetadataDefResponse> updateBMDefs(List<AtlasBusinessMetadataDef> bmDefs) throws IOException, RestClientException {
        return this.updateBMDefs(DEFAULT_REQUEST_PROPERTIES, bmDefs);
    }

    public List<BusinessMetadataDefResponse> updateBMDefs(Map<String, String> requestProperties, List<AtlasBusinessMetadataDef> bmDefs) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(bmDefs);
        return (List)this.httpRequest(path, "PUT", payload, requestProperties, BM_DEFS_TYPE);
    }

    public String deleteBMDef(String bmName) throws IOException, RestClientException {
        return this.deleteBMDef(DEFAULT_REQUEST_PROPERTIES, bmName);
    }

    public String deleteBMDef(Map<String, String> requestProperties, String bmName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/types/businessmetadatadefs/{bmName}");
        String path = builder.build(new Object[]{bmName}).toString();
        return (String)this.httpRequest(path, "DELETE", null, requestProperties, STRING_TYPE);
    }

    public List<TagResponse> createTags(List<Tag> tags) throws IOException, RestClientException {
        return this.createTags(DEFAULT_REQUEST_PROPERTIES, tags);
    }

    public List<TagResponse> createTags(Map<String, String> requestProperties, List<Tag> tags) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/tags");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(tags);
        return (List)this.httpRequest(path, "POST", payload, requestProperties, TAGS_TYPE);
    }

    public List<TagResponse> getTags(String typeName, String qualifiedName) throws IOException, RestClientException {
        return this.getTags(DEFAULT_REQUEST_PROPERTIES, typeName, qualifiedName);
    }

    public List<TagResponse> getTags(Map<String, String> requestProperties, String typeName, String qualifiedName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}/tags");
        String path = builder.build(new Object[]{typeName, qualifiedName}).toString();
        return (List)this.httpRequest(path, "GET", null, requestProperties, TAGS_TYPE);
    }

    public List<TagResponse> updateTags(List<Tag> tags) throws IOException, RestClientException {
        return this.updateTags(DEFAULT_REQUEST_PROPERTIES, tags);
    }

    public List<TagResponse> updateTags(Map<String, String> requestProperties, List<Tag> tags) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/tags");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(tags);
        return (List)this.httpRequest(path, "PUT", payload, requestProperties, TAGS_TYPE);
    }

    public void deleteTag(String typeName, String qualifiedName, String tagName) throws IOException, RestClientException {
        this.deleteTag(DEFAULT_REQUEST_PROPERTIES, typeName, qualifiedName, tagName);
    }

    public void deleteTag(Map<String, String> requestProperties, String typeName, String qualifiedName, String tagName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}/tags/{tagName}");
        String path = builder.build(new Object[]{typeName, qualifiedName, tagName}).toString();
        this.httpRequest(path, "DELETE", null, requestProperties, VOID_TYPE);
    }

    public List<BusinessMetadataResponse> createBMs(List<BusinessMetadata> bms) throws IOException, RestClientException {
        return this.createBMs(DEFAULT_REQUEST_PROPERTIES, bms);
    }

    public List<BusinessMetadataResponse> createBMs(Map<String, String> requestProperties, List<BusinessMetadata> bms) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/businessmetadata");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(bms);
        return (List)this.httpRequest(path, "POST", payload, requestProperties, BMS_TYPE);
    }

    public List<BusinessMetadataResponse> getBMs(String typeName, String qualifiedName) throws IOException, RestClientException {
        return this.getBMs(DEFAULT_REQUEST_PROPERTIES, typeName, qualifiedName);
    }

    public List<BusinessMetadataResponse> getBMs(Map<String, String> requestProperties, String typeName, String qualifiedName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}/businessmetadata");
        String path = builder.build(new Object[]{typeName, qualifiedName}).toString();
        return (List)this.httpRequest(path, "GET", null, requestProperties, BMS_TYPE);
    }

    public List<BusinessMetadataResponse> updateBMs(List<BusinessMetadata> bms) throws IOException, RestClientException {
        return this.updateBMs(DEFAULT_REQUEST_PROPERTIES, bms);
    }

    public List<BusinessMetadataResponse> updateBMs(Map<String, String> requestProperties, List<BusinessMetadata> bms) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/businessmetadata");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(bms);
        return (List)this.httpRequest(path, "PUT", payload, requestProperties, BMS_TYPE);
    }

    public void deleteBM(String typeName, String qualifiedName, String bmName) throws IOException, RestClientException {
        this.deleteBM(DEFAULT_REQUEST_PROPERTIES, typeName, qualifiedName, bmName);
    }

    public void deleteBM(Map<String, String> requestProperties, String typeName, String qualifiedName, String bmName) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/type/{typeName}/name/{qualifiedName}/businessmetadata/{bmName}");
        String path = builder.build(new Object[]{typeName, qualifiedName, bmName}).toString();
        this.httpRequest(path, "DELETE", null, requestProperties, VOID_TYPE);
    }

    @Deprecated
    public List<SchemaTagsResponse> updateSchemaTags(Map<String, String> requestProperties, List<SchemaMetadata> schemaMetadataList) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity/schematags");
        String path = builder.build(new Object[0]).toString();
        byte[] payload = JacksonMapper.INSTANCE.writeValueAsBytes(schemaMetadataList);
        return (List)this.httpRequest(path, "POST", payload, requestProperties, SCHEMA_TAGS_TYPE);
    }

    public JsonNode graphQL(String query) throws IOException, RestClientException {
        Map<String, String> requestProperties = Collections.singletonMap("Content-Type", "application/graphql");
        return this.graphQL(requestProperties, query, Collections.emptyMap(), null);
    }

    public JsonNode graphQL(String query, Map<String, Object> variables) throws IOException, RestClientException {
        Map<String, String> requestProperties = Collections.singletonMap("Content-Type", "application/graphql");
        return this.graphQL(requestProperties, query, variables, null);
    }

    public JsonNode graphQL(Map<String, String> requestProperties, String query, Map<String, Object> variables, Boolean refill) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/graphql");
        if (variables != null && !variables.isEmpty()) {
            builder.queryParam("variables", new Object[]{URLEncoder.encode(OBJECT_MAPPER.writeValueAsString(variables), "UTF-8")});
        }
        if (refill != null) {
            builder.queryParam("refill", new Object[]{refill});
        }
        String path = builder.build(new Object[0]).toString();
        return (JsonNode)this.httpRequest(path, "POST", query.getBytes(StandardCharsets.UTF_8), requestProperties, JSON_NODE_TYPE);
    }

    public void postEntitySnapshot(String tenant, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UriBuilder builder = UriBuilder.fromPath((String)"/catalog/v1/entity-notifications-snapshot");
        String path = builder.build(new Object[0]).toString();
        try {
            this.httpRequest(path, "POST", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the snapshot request", new Object[0]), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }
}

