/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.diskstorage.lucene;

import io.confluent.catalog.diskstorage.lucene.LuceneIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.graphdb.types.ParameterType;

public class LuceneCustomAnalyzer
extends DelegatingAnalyzerWrapper {
    private static final String KEYWORD_ANALYZER = KeywordAnalyzer.class.getName();
    private static final String STANDARD_ANALYZER = StandardAnalyzer.class.getName();
    private final String store;
    private volatile KeyInformation.IndexRetriever informations;
    private final Map<String, Analyzer> analyzers = new HashMap<String, Analyzer>();

    public LuceneCustomAnalyzer(String store, KeyInformation.IndexRetriever informations, Analyzer.ReuseStrategy fallbackStrategy) {
        super(fallbackStrategy);
        this.store = store;
        this.informations = informations;
        this.analyzers.put(KEYWORD_ANALYZER, (Analyzer)new KeywordAnalyzer());
        this.analyzers.put(STANDARD_ANALYZER, (Analyzer)new StandardAnalyzer());
    }

    public void setInformations(KeyInformation.IndexRetriever informations) {
        this.informations = informations;
    }

    protected final Analyzer getWrappedAnalyzer(String fieldName) {
        if ("_____elementid".equals(fieldName)) {
            return this.analyzerFor(KEYWORD_ANALYZER);
        }
        KeyInformation keyInformation = this.informations.get(this.store, LuceneIndex.getOrigFieldName(fieldName));
        if (keyInformation != null && keyInformation.getDataType().equals(UUID.class)) {
            return this.analyzerFor(KEYWORD_ANALYZER);
        }
        if (keyInformation == null || !String.class.isAssignableFrom(keyInformation.getDataType())) {
            return this.analyzerFor(STANDARD_ANALYZER);
        }
        Parameter[] parameters = keyInformation.getParameters();
        Mapping mapping = LuceneIndex.isDualFieldName(fieldName) ? LuceneIndex.getDualMapping(keyInformation) : (Mapping)ParameterType.MAPPING.findParameter(parameters, (Object)Mapping.DEFAULT);
        return this.analyzerFor(LuceneCustomAnalyzer.analyzerNameFor(parameters, mapping, KEYWORD_ANALYZER, STANDARD_ANALYZER));
    }

    private static String analyzerNameFor(Parameter[] parameters, Mapping mapping, String defaultStringAnalyzer, String defaultTextAnalyzer) {
        switch (mapping) {
            case PREFIX_TREE: {
                throw new RuntimeException("Prefix-tree is an unsupported mapping for string data & custom analyzers");
            }
            case STRING: {
                return (String)ParameterType.STRING_ANALYZER.findParameter(parameters, (Object)defaultStringAnalyzer);
            }
            case TEXT: 
            case TEXTSTRING: 
            case DEFAULT: {
                return (String)ParameterType.TEXT_ANALYZER.findParameter(parameters, (Object)defaultTextAnalyzer);
            }
        }
        throw new RuntimeException("Not supported");
    }

    private Analyzer analyzerFor(String analyzerName) {
        if (!this.analyzers.containsKey(analyzerName)) {
            try {
                Class<?> classDefinition = Class.forName(analyzerName);
                this.analyzers.put(analyzerName, (Analyzer)classDefinition.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Analyzer cannot be instanciated for class " + analyzerName, e);
            }
        }
        return this.analyzers.get(analyzerName);
    }
}

