/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.metrics.MetricsManager;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class AtlasGraphUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGraphUtils.class);
    private static boolean USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY = true;
    private static String INDEX_SEARCH_PREFIX;
    private final boolean useAtlasIndexQueryToFindEntityByUniqueAttr;
    private final MetricsManager metricsManager;

    @Inject
    public AtlasGraphUtils(SchemaRegistry schemaRegistry, MetricsManager metricsManager) {
        try {
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
            this.useAtlasIndexQueryToFindEntityByUniqueAttr = dataCatalogConfig.useAtlasIndexQueryToFindEntityByUniqueAttr();
            this.metricsManager = metricsManager;
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate AtlasGraphUtils", e);
        }
        LOG.info("atlas.use.index.query.to.find.entity.by.unique.attributes=" + this.useAtlasIndexQueryToFindEntityByUniqueAttr);
    }

    public AtlasVertex getVertexByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues, AtlasEntity.Status status) throws AtlasBaseException {
        AtlasVertex vertex = this.findByUniqueAttributes(entityType, attrValues, status);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{entityType.getTypeName(), attrValues.toString()});
        }
        return vertex;
    }

    public String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues, AtlasEntity.Status status) throws AtlasBaseException {
        AtlasVertex vertexByUniqueAttributes = this.getVertexByUniqueAttributes(entityType, attrValues, status);
        return AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)vertexByUniqueAttributes);
    }

    public AtlasVertex findByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues, AtlasEntity.Status status) {
        long startTimeMs = System.currentTimeMillis();
        AtlasVertex vertex = null;
        Map uniqueAttributes = entityType.getUniqAttributes();
        if (MapUtils.isNotEmpty((Map)uniqueAttributes) && MapUtils.isNotEmpty(attrValues)) {
            for (AtlasStructType.AtlasAttribute attribute : uniqueAttributes.values()) {
                Object attrValue = attrValues.get(attribute.getName());
                if (attrValue == null) continue;
                if (this.canUseIndexQuery(entityType, attribute.getName())) {
                    vertex = this.getAtlasVertexFromIndexQuery(entityType, attribute, attrValue, status);
                } else if (status == AtlasEntity.Status.ACTIVE && USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY && attribute.getVertexUniquePropertyName() != null) {
                    vertex = this.findByTypeAndUniquePropertyName(entityType.getTypeName(), attribute.getVertexUniquePropertyName(), attrValue);
                    if (vertex == null && !entityType.getAllSubTypes().isEmpty()) {
                        vertex = this.findBySuperTypeAndUniquePropertyName(entityType.getTypeName(), attribute.getVertexUniquePropertyName(), attrValue);
                    }
                } else {
                    vertex = this.findByTypeAndPropertyName(entityType.getTypeName(), attribute.getVertexPropertyName(), attrValue, status);
                    if (vertex == null && !entityType.getAllSubTypes().isEmpty()) {
                        vertex = this.findBySuperTypeAndPropertyName(entityType.getTypeName(), attribute.getVertexPropertyName(), attrValue, status);
                    }
                }
                if (vertex == null) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("findByUniqueAttributes(type={}, attrName={}, attrValue={}: found vertex {}", new Object[]{entityType.getTypeName(), attribute.getName(), attrValue, vertex});
                break;
            }
        }
        this.metricsManager.recordFindByUniqueAttributes(System.currentTimeMillis() - startTimeMs);
        return vertex;
    }

    public AtlasVertex findByTypeAndUniquePropertyName(String typeName, String propertyName, Object attrVal) {
        long startTimeMs = System.currentTimeMillis();
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal);
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        this.metricsManager.recordFindByTypeAndUniquePropertyName(System.currentTimeMillis() - startTimeMs);
        return vertex;
    }

    public AtlasVertex findBySuperTypeAndUniquePropertyName(String typeName, String propertyName, Object attrVal) {
        long startTimeMs = System.currentTimeMillis();
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.SUPER_TYPES_PROPERTY_KEY, (Object)typeName).has(propertyName, attrVal);
        Iterator results = query.vertices().iterator();
        AtlasVertex vertex = results.hasNext() ? (AtlasVertex)results.next() : null;
        this.metricsManager.recordFindBySuperTypeAndUniquePropertyName(System.currentTimeMillis() - startTimeMs);
        return vertex;
    }

    public AtlasVertex findByTypeAndPropertyName(String typeName, String propertyName, Object attrVal, AtlasEntity.Status status) {
        long startTimeMs = System.currentTimeMillis();
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(propertyName, attrVal);
        AtlasVertex vertex = null;
        for (AtlasVertex v : query.vertices()) {
            if (!GraphHelper.getTypeName((AtlasElement)v).equals(typeName) || GraphHelper.getStatus((AtlasVertex)v) != status) continue;
            vertex = v;
            break;
        }
        this.metricsManager.recordFindByTypeAndPropertyName(System.currentTimeMillis() - startTimeMs);
        return vertex;
    }

    public AtlasVertex findBySuperTypeAndPropertyName(String typeName, String propertyName, Object attrVal, AtlasEntity.Status status) {
        long startTimeMs = System.currentTimeMillis();
        AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(propertyName, attrVal);
        AtlasVertex vertex = null;
        for (AtlasVertex v : query.vertices()) {
            if (!GraphHelper.getSuperTypeNames((AtlasVertex)v).contains(typeName) || GraphHelper.getStatus((AtlasVertex)v) != status) continue;
            vertex = v;
            break;
        }
        this.metricsManager.recordFindBySuperTypeAndPropertyName(System.currentTimeMillis() - startTimeMs);
        return vertex;
    }

    private boolean canUseIndexQuery(AtlasEntityType entityType, String attributeName) {
        boolean ret = false;
        if (this.useAtlasIndexQueryToFindEntityByUniqueAttr) {
            String typeAndSubTypesQryStr = entityType.getTypeAndAllSubTypesQryStr();
            boolean bl = ret = typeAndSubTypesQryStr.length() <= SearchProcessor.MAX_QUERY_STR_LENGTH_TYPES;
            if (ret) {
                Set indexSet = AtlasGraphProvider.getGraphInstance().getVertexIndexKeys();
                try {
                    ret = indexSet.contains(entityType.getVertexPropertyName(attributeName));
                }
                catch (AtlasBaseException ex) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private AtlasVertex getAtlasVertexFromIndexQuery(AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute, Object attrVal, AtlasEntity.Status status) {
        long startTimeMs = System.currentTimeMillis();
        String propertyName = attribute.getVertexPropertyName();
        AtlasIndexQuery query = this.getIndexQuery(entityType, propertyName, attrVal.toString(), status);
        AtlasVertex vertex = null;
        Iterator iter = query.vertices();
        while (iter.hasNext()) {
            String vertexVal;
            String s;
            AtlasIndexQuery.Result result = (AtlasIndexQuery.Result)iter.next();
            vertex = result.getVertex();
            if (vertex == null || !vertex.getPropertyKeys().contains(Constants.GUID_PROPERTY_KEY)) continue;
            String typeNameInVertex = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
            if (!entityType.getTypeAndAllSubTypes().contains(typeNameInVertex)) {
                LOG.warn("incorrect vertex type from index-query: expected='{}'; found='{}'", (Object)entityType.getTypeName(), (Object)typeNameInVertex);
                continue;
            }
            if (attrVal.getClass() != String.class || (s = (String)attrVal).equalsIgnoreCase(vertexVal = (String)vertex.getProperty(propertyName, String.class))) break;
            LOG.warn("incorrect match from index-query for property {}: expected='{}'; found='{}'", new Object[]{propertyName, s, vertexVal});
        }
        this.metricsManager.recordGetVertexFromIndexQuery(System.currentTimeMillis() - startTimeMs);
        return vertex;
    }

    private AtlasIndexQuery getIndexQuery(AtlasEntityType entityType, String propertyName, String value, AtlasEntity.Status status) {
        StringBuilder sb = new StringBuilder();
        sb.append(INDEX_SEARCH_PREFIX + "\"").append("__typeName").append("\":").append(entityType.getTypeAndAllSubTypesQryStr()).append(" AND ").append(INDEX_SEARCH_PREFIX + "\"").append(propertyName).append("\":").append(AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)value)).append(" AND ").append(INDEX_SEARCH_PREFIX + "\"").append(Constants.STATE_PROPERTY_KEY).append("\":").append(status.name());
        return AtlasGraphProvider.getGraphInstance().indexQuery("vertex_index", sb.toString());
    }

    static {
        try {
            Configuration conf = ApplicationProperties.get();
            USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY = conf.getBoolean("atlas.unique.index.property.to.find.entity", USE_UNIQUE_INDEX_PROPERTY_TO_FIND_ENTITY);
            INDEX_SEARCH_PREFIX = conf.getString("atlas.graph.index.search.vertex.prefix", "$v$");
        }
        catch (Exception excp) {
            LOG.error("Error reading configuration", (Throwable)excp);
        }
    }
}

