/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.hook.SchemaOperationContext;
import io.confluent.catalog.model.instance.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaAtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaAtlasHook.class);

    public AtlasEntity createSchema(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_SCHEMA.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, schema.getName());
        entity.setAttribute("namespace", (Object)this.getNamespace(schema));
        entity.setAttribute("doc", (Object)schema.getDoc());
        entity.setAttribute("schemaType", (Object)"AVRO");
        AtlasEntity type = this.createType(ctx, id, schema);
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(Collections.singleton(type)));
        type.setRelationshipAttribute("schema", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createType(SchemaOperationContext ctx, int id, Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                return this.createRecord(ctx, id, schema);
            }
            case ENUM: {
                return this.createEnum(ctx, id, schema);
            }
            case ARRAY: {
                return this.createArray(ctx, id, schema);
            }
            case MAP: {
                return this.createMap(ctx, id, schema);
            }
            case UNION: {
                return this.createUnion(ctx, id, schema);
            }
            case FIXED: {
                return this.createFixed(ctx, id, schema);
            }
        }
        return this.createPrimitive(ctx, id, schema);
    }

    private AtlasEntity createRecord(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_RECORD.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, schema.getName());
        entity.setAttribute("namespace", (Object)this.getNamespace(schema));
        entity.setAttribute("doc", (Object)schema.getDoc());
        entity.setAttribute("aliases", this.getAliases(schema));
        Object prop = schema.getObjectProp("confluent:tags");
        if (prop instanceof List) {
            entity.setClassifications(((List)prop).stream().map(t -> new Tag(ctx.getTenant(), t.toString())).collect(Collectors.toList()));
        }
        List fields = schema.getFields().stream().map(f -> this.createField(ctx, id, schema, (Schema.Field)f)).collect(Collectors.toList());
        entity.setRelationshipAttribute("fields", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(fields));
        for (AtlasEntity field : fields) {
            field.setRelationshipAttribute("record", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createField(SchemaOperationContext ctx, int id, Schema schema, Schema.Field schemaField) {
        Object prop;
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + "." + schemaField.name());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_FIELD.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, schemaField.name());
        entity.setAttribute("doc", (Object)schemaField.doc());
        entity.setAttribute("aliases", (Object)schemaField.aliases());
        Object defaultVal = null;
        try {
            defaultVal = schemaField.defaultVal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultVal != null) {
            entity.setAttribute("default", (Object)defaultVal.toString());
        }
        if ((prop = schemaField.getObjectProp("confluent:tags")) instanceof List) {
            entity.setClassifications(((List)prop).stream().map(t -> new Tag(ctx.getTenant(), t.toString())).collect(Collectors.toList()));
        }
        AtlasEntity type = this.createType(ctx, id, schemaField.schema());
        entity.setRelationshipAttribute("type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)type));
        type.setRelationshipAttribute("field", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createEnum(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ENUM.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, schema.getName());
        entity.setAttribute("namespace", (Object)this.getNamespace(schema));
        entity.setAttribute("doc", (Object)schema.getDoc());
        entity.setAttribute("aliases", this.getAliases(schema));
        entity.setAttribute("symbols", (Object)schema.getEnumSymbols());
        if (schema.getEnumDefault() != null) {
            entity.setAttribute("default", (Object)schema.getEnumDefault());
        }
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createArray(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + "<" + schema.getElementType() + ">");
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ARRAY.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        AtlasEntity type = this.createType(ctx, id, schema.getElementType());
        entity.setRelationshipAttribute("type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)type));
        type.setRelationshipAttribute("array", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createMap(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + "<string," + schema.getValueType() + ">");
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_MAP.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        AtlasEntity type = this.createType(ctx, id, schema.getValueType());
        entity.setRelationshipAttribute("valueType", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)type));
        type.setRelationshipAttribute("mapValue", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createUnion(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + ctx.incrementNameIndex());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        entity.setAttribute("kind", (Object)"oneof");
        List types = schema.getTypes().stream().map(s -> this.createType(ctx, id, (Schema)s)).collect(Collectors.toList());
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(types));
        for (AtlasEntity type : types) {
            type.setRelationshipAttribute("combined", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createFixed(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_FIXED.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, schema.getName());
        entity.setAttribute("namespace", (Object)this.getNamespace(schema));
        entity.setAttribute("doc", (Object)schema.getDoc());
        entity.setAttribute("aliases", this.getAliases(schema));
        entity.setAttribute("size", (Object)schema.getFixedSize());
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createPrimitive(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_PRIMITIVE.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        entity.setAttribute("type", (Object)schema.getType().getName());
        ctx.createOrUpdate(entity);
        return entity;
    }

    public void deleteSchema(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_SCHEMA.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, schema, purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteType(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        switch (schema.getType()) {
            case RECORD: {
                this.deleteRecord(ctx, id, schema, purge);
                break;
            }
            case ENUM: {
                this.deleteEnum(ctx, id, schema, purge);
                break;
            }
            case ARRAY: {
                this.deleteArray(ctx, id, schema, purge);
                break;
            }
            case MAP: {
                this.deleteMap(ctx, id, schema, purge);
                break;
            }
            case UNION: {
                this.deleteUnion(ctx, id, schema, purge);
                break;
            }
            case FIXED: {
                this.deleteFixed(ctx, id, schema, purge);
                break;
            }
            default: {
                this.deletePrimitive(ctx, id, schema, purge);
            }
        }
    }

    private void deleteRecord(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        if (ctx.isDeleted(qualifiedName)) {
            return;
        }
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_RECORD.getName(), "qualifiedName", (Object)qualifiedName);
        ctx.addDeleted(qualifiedName);
        schema.getFields().forEach(f -> this.deleteField(ctx, id, schema, (Schema.Field)f, purge));
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteField(SchemaOperationContext ctx, int id, Schema schema, Schema.Field schemaField, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + "." + schemaField.name());
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_FIELD.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, schemaField.schema(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteEnum(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ENUM.getName(), "qualifiedName", (Object)qualifiedName);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteArray(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + "<" + schema.getElementType() + ">");
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ARRAY.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, schema.getElementType(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteMap(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + "<string," + schema.getValueType() + ">");
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_MAP.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, schema.getValueType(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteUnion(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName() + ctx.incrementNameIndex());
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        schema.getTypes().forEach(s -> this.deleteType(ctx, id, (Schema)s, purge));
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteFixed(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_FIXED.getName(), "qualifiedName", (Object)qualifiedName);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deletePrimitive(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, schema.getFullName());
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_PRIMITIVE.getName(), "qualifiedName", (Object)qualifiedName);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private String getNamespace(Schema schema) {
        try {
            return schema.getNamespace();
        }
        catch (AvroRuntimeException e) {
            return "";
        }
    }

    private Set<String> getAliases(Schema schema) {
        try {
            return schema.getAliases();
        }
        catch (AvroRuntimeException e) {
            return Collections.emptySet();
        }
    }
}

