/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.hook.SchemaOperationContext;
import io.confluent.catalog.model.instance.Tag;
import io.confluent.catalog.util.JsonSchemaComparator;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.type.AtlasTypeUtil;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaAtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSchemaAtlasHook.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public AtlasEntity createSchema(SchemaOperationContext ctx, int id, Schema schema) {
        String qualifiedName = ctx.getQualifiedName(id);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_SCHEMA.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        entity.setAttribute("namespace", (Object)schema.getId());
        entity.setAttribute("schemaType", (Object)"JSON");
        String scope = "";
        AtlasEntity type = this.createType(ctx, scope, id, schema);
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(Collections.singleton(type)));
        type.setRelationshipAttribute("schema", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createType(SchemaOperationContext ctx, String scope, int id, Schema schema) {
        if (schema instanceof StringSchema) {
            return this.createPrimitive(ctx, scope, "string", id, schema);
        }
        if (schema instanceof NumberSchema) {
            return this.createPrimitive(ctx, scope, "number", id, schema);
        }
        if (schema instanceof BooleanSchema) {
            return this.createPrimitive(ctx, scope, "boolean", id, schema);
        }
        if (schema instanceof NullSchema) {
            return this.createPrimitive(ctx, scope, "null", id, schema);
        }
        if (schema instanceof ConstSchema) {
            return this.createConst(ctx, scope, id, (ConstSchema)schema);
        }
        if (schema instanceof EnumSchema) {
            return this.createEnum(ctx, scope, id, (EnumSchema)schema);
        }
        if (schema instanceof CombinedSchema) {
            return this.createCombined(ctx, scope, id, (CombinedSchema)schema);
        }
        if (schema instanceof NotSchema) {
            return this.createNot(ctx, scope, id, (NotSchema)schema);
        }
        if (schema instanceof ConditionalSchema) {
            return this.createConditional(ctx, scope, id, (ConditionalSchema)schema);
        }
        if (schema instanceof EmptySchema) {
            return this.createEmpty(ctx, scope, id, (EmptySchema)schema);
        }
        if (schema instanceof FalseSchema) {
            return this.createFalse(ctx, scope, id, (FalseSchema)schema);
        }
        if (schema instanceof ObjectSchema) {
            return this.createRecord(ctx, scope, id, (ObjectSchema)schema);
        }
        if (schema instanceof ArraySchema) {
            return this.createArray(ctx, scope, id, (ArraySchema)schema);
        }
        if (schema instanceof ReferenceSchema) {
            return this.createRef(ctx, scope, id, (ReferenceSchema)schema);
        }
        return this.createEmpty(ctx, scope, id, EmptySchema.INSTANCE);
    }

    private AtlasEntity createRecord(SchemaOperationContext ctx, String scope, int id, ObjectSchema schema) {
        Object prop;
        String name = "object";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_RECORD.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        if ((prop = schema.getUnprocessedProperties().get("confluent:tags")) instanceof List) {
            entity.setClassifications(((List)prop).stream().map(t -> new Tag(ctx.getTenant(), t.toString())).collect(Collectors.toList()));
        }
        List required = schema.getRequiredProperties();
        TreeMap propertySchemas = new TreeMap(schema.getPropertySchemas());
        List fields = propertySchemas.entrySet().stream().map(e -> this.createField(ctx, scopedName + ".", id, (Schema)e.getValue(), (String)e.getKey(), required.contains(e.getKey()))).collect(Collectors.toList());
        entity.setRelationshipAttribute("fields", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(fields));
        for (AtlasEntity field : fields) {
            field.setRelationshipAttribute("record", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createField(SchemaOperationContext ctx, String scope, int id, Schema schema, String fieldName, boolean required) {
        Object prop;
        String scopedName = scope + fieldName;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_FIELD.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, fieldName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        if ((prop = schema.getUnprocessedProperties().get("confluent:tags")) instanceof List) {
            entity.setClassifications(((List)prop).stream().map(t -> new Tag(ctx.getTenant(), t.toString())).collect(Collectors.toList()));
        }
        AtlasEntity type = this.createType(ctx, scopedName + ".", id, schema);
        entity.setRelationshipAttribute("type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)type));
        type.setRelationshipAttribute("field", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        if (required) {
            entity.setAttribute("label", (Object)"required");
        }
        ctx.createOrUpdate(entity);
        return entity;
    }

    private void createDefinitions(SchemaOperationContext ctx, String scope, int id, Schema schema, AtlasEntity entity) {
        List<AtlasEntity> typeEntities = this.createDefinitions(ctx, scope, id, schema.getUnprocessedProperties());
        if (!typeEntities.isEmpty()) {
            entity.setRelationshipAttribute("child_types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(typeEntities));
            for (AtlasEntity typeEntity : typeEntities) {
                typeEntity.setRelationshipAttribute("parent_type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
            }
        }
    }

    private List<AtlasEntity> createDefinitions(SchemaOperationContext ctx, String scope, int id, Map<String, Object> unprocessedProperties) {
        try {
            ArrayList<AtlasEntity> entities = new ArrayList<AtlasEntity>();
            Map defs = (Map)unprocessedProperties.get("definitions");
            if (defs != null) {
                for (Map.Entry entry : defs.entrySet()) {
                    if (!(entry.getValue() instanceof Map)) continue;
                    Map<String, Object> rawSchema = this.replaceRefs((Map)entry.getValue());
                    JsonNode jsonNode = MAPPER.valueToTree(rawSchema);
                    JsonSchema jsonSchema = new JsonSchema(jsonNode);
                    entities.add(this.createType(ctx, scope + "definitions." + (String)entry.getKey() + ".", id, jsonSchema.rawSchema()));
                }
            }
            return entities;
        }
        catch (Exception e) {
            LOG.warn("Could not create definitions", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Map<String, Object> replaceRefs(Map<String, Object> defs) {
        HashMap<String, Object> result = new HashMap<String, Object>(defs);
        if (result.containsKey("$ref")) {
            result.put("$ref", "#");
        }
        for (Map.Entry entry : result.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            entry.setValue(this.replaceRefs((Map)entry.getValue()));
        }
        return result;
    }

    private AtlasEntity createConst(SchemaOperationContext ctx, String scope, int id, ConstSchema schema) {
        String name = "const";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ENUM.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        entity.setAttribute("symbols", Collections.singletonList(schema.getPermittedValue().toString()));
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createEnum(SchemaOperationContext ctx, String scope, int id, EnumSchema schema) {
        String name = "enum";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ENUM.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        entity.setAttribute("symbols", schema.getPossibleValues().stream().map(Objects::toString).collect(Collectors.toList()));
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createArray(SchemaOperationContext ctx, String scope, int id, ArraySchema schema) {
        String name = "array";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ARRAY.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        AtlasEntity type = this.createType(ctx, scopedName + ".", id, schema.getAllItemSchema());
        entity.setRelationshipAttribute("type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)type));
        type.setRelationshipAttribute("array", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createRef(SchemaOperationContext ctx, String scope, int id, ReferenceSchema schema) {
        String kind;
        String name = kind = "ref";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("kind", (Object)kind);
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createCombined(SchemaOperationContext ctx, String scope, int id, CombinedSchema schema) {
        String kind;
        String name = kind = JsonSchemaComparator.getCriterion(schema);
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("kind", (Object)kind);
        ArrayList<Schema> subschemas = new ArrayList<Schema>(schema.getSubschemas());
        subschemas.sort(new JsonSchemaComparator());
        ArrayList<AtlasEntity> types = new ArrayList<AtlasEntity>();
        for (int i = 0; i < subschemas.size(); ++i) {
            Schema subschema = (Schema)subschemas.get(i);
            types.add(this.createType(ctx, scopedName + "." + i + ".", id, subschema));
        }
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(types));
        for (AtlasEntity type : types) {
            type.setRelationshipAttribute("combined", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createNot(SchemaOperationContext ctx, String scope, int id, NotSchema schema) {
        String kind;
        String name = kind = "not";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("kind", (Object)kind);
        AtlasEntity type = this.createType(ctx, scopedName + ".", id, schema.getMustNotMatch());
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(Collections.singletonList(type)));
        type.setRelationshipAttribute("combined", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createConditional(SchemaOperationContext ctx, String scope, int id, ConditionalSchema schema) {
        String kind;
        String name = kind = "conditional";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("kind", (Object)kind);
        ArrayList<AtlasEntity> types = new ArrayList<AtlasEntity>();
        types.add(this.createType(ctx, scopedName + ".if.", id, (Schema)schema.getIfSchema().orElse(EmptySchema.INSTANCE)));
        types.add(this.createType(ctx, scopedName + ".then.", id, (Schema)schema.getThenSchema().orElse(EmptySchema.INSTANCE)));
        types.add(this.createType(ctx, scopedName + ".else.", id, (Schema)schema.getElseSchema().orElse(EmptySchema.INSTANCE)));
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(types));
        for (AtlasEntity type : types) {
            type.setRelationshipAttribute("combined", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createEmpty(SchemaOperationContext ctx, String scope, int id, EmptySchema schema) {
        String kind;
        String name = kind = "empty";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("kind", (Object)kind);
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createFalse(SchemaOperationContext ctx, String scope, int id, FalseSchema schema) {
        String kind;
        String name = kind = "false";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_COMBINED.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("kind", (Object)kind);
        this.createDefinitions(ctx, scopedName + ".", id, (Schema)schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createPrimitive(SchemaOperationContext ctx, String scope, String type, int id, Schema schema) {
        String name = type;
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_PRIMITIVE.getName());
        String title = schema.getTitle();
        String searchName = title != null && !title.isEmpty() ? title : "";
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, searchName);
        entity.setAttribute("doc", (Object)schema.getDescription());
        if (schema.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)schema.getDefaultValue().toString());
        }
        entity.setAttribute("type", (Object)type);
        this.createDefinitions(ctx, scopedName + ".", id, schema, entity);
        ctx.createOrUpdate(entity);
        return entity;
    }

    public void deleteSchema(SchemaOperationContext ctx, int id, Schema schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_SCHEMA.getName(), "qualifiedName", (Object)qualifiedName);
        String scope = "";
        this.deleteType(ctx, scope, id, schema, purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteType(SchemaOperationContext ctx, String scope, int id, Schema schema, boolean purge) {
        if (schema instanceof StringSchema) {
            this.deletePrimitive(ctx, scope, "string", id, schema, purge);
        } else if (schema instanceof NumberSchema) {
            this.deletePrimitive(ctx, scope, "number", id, schema, purge);
        } else if (schema instanceof BooleanSchema) {
            this.deletePrimitive(ctx, scope, "boolean", id, schema, purge);
        } else if (schema instanceof NullSchema) {
            this.deletePrimitive(ctx, scope, "null", id, schema, purge);
        } else if (schema instanceof ConstSchema) {
            this.deleteConst(ctx, scope, id, (ConstSchema)schema, purge);
        } else if (schema instanceof EnumSchema) {
            this.deleteEnum(ctx, scope, id, (EnumSchema)schema, purge);
        } else if (schema instanceof CombinedSchema) {
            this.deleteCombined(ctx, scope, id, (CombinedSchema)schema, purge);
        } else if (schema instanceof EmptySchema) {
            this.deleteEmpty(ctx, scope, id, (EmptySchema)schema, purge);
        } else if (schema instanceof FalseSchema) {
            this.deleteFalse(ctx, scope, id, (FalseSchema)schema, purge);
        } else if (schema instanceof NotSchema) {
            this.deleteNot(ctx, scope, id, (NotSchema)schema, purge);
        } else if (schema instanceof ConditionalSchema) {
            this.deleteConditional(ctx, scope, id, (ConditionalSchema)schema, purge);
        } else if (schema instanceof ObjectSchema) {
            this.deleteRecord(ctx, scope, id, (ObjectSchema)schema, purge);
        } else if (schema instanceof ArraySchema) {
            this.deleteArray(ctx, scope, id, (ArraySchema)schema, purge);
        } else if (schema instanceof ReferenceSchema) {
            this.deleteRef(ctx, scope, id, (ReferenceSchema)schema, purge);
        } else {
            this.deleteEmpty(ctx, scope, id, EmptySchema.INSTANCE, purge);
        }
    }

    private void deleteRecord(SchemaOperationContext ctx, String scope, int id, ObjectSchema schema, boolean purge) {
        String name = "object";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        if (ctx.isDeleted(qualifiedName)) {
            return;
        }
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_RECORD.getName(), "qualifiedName", (Object)qualifiedName);
        ctx.addDeleted(qualifiedName);
        TreeMap<String, Schema> propertySchemas = new TreeMap<String, Schema>(schema.getPropertySchemas());
        propertySchemas.forEach((key, value) -> this.deleteField(ctx, scopedName + ".", id, (Schema)value, (String)key, purge));
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteField(SchemaOperationContext ctx, String scope, int id, Schema schema, String fieldName, boolean purge) {
        String scopedName = scope + fieldName;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_FIELD.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, scopedName + ".", id, schema, purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteDefinitions(SchemaOperationContext ctx, String scope, int id, Map<String, Object> unprocessedProperties, boolean purge) {
        try {
            Map defs = (Map)unprocessedProperties.get("definitions");
            if (defs != null) {
                for (Map.Entry entry : defs.entrySet()) {
                    if (!(entry.getValue() instanceof Map)) continue;
                    Map<String, Object> rawSchema = this.replaceRefs((Map)entry.getValue());
                    JsonNode jsonNode = MAPPER.valueToTree(rawSchema);
                    JsonSchema jsonSchema = new JsonSchema(jsonNode);
                    this.deleteType(ctx, scope + "definitions." + (String)entry.getKey() + ".", id, jsonSchema.rawSchema(), purge);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not delete definitions", (Throwable)e);
        }
    }

    private void deleteConst(SchemaOperationContext ctx, String scope, int id, ConstSchema schema, boolean purge) {
        String name = "const";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ENUM.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteEnum(SchemaOperationContext ctx, String scope, int id, EnumSchema schema, boolean purge) {
        String name = "enum";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ENUM.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteArray(SchemaOperationContext ctx, String scope, int id, ArraySchema schema, boolean purge) {
        String name = "array";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ARRAY.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, scopedName + ".", id, schema.getAllItemSchema(), purge);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteRef(SchemaOperationContext ctx, String scope, int id, ReferenceSchema schema, boolean purge) {
        String kind;
        String name = kind = "ref";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteCombined(SchemaOperationContext ctx, String scope, int id, CombinedSchema schema, boolean purge) {
        String kind;
        String name = kind = JsonSchemaComparator.getCriterion(schema);
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        ArrayList<Schema> subschemas = new ArrayList<Schema>(schema.getSubschemas());
        subschemas.sort(new JsonSchemaComparator());
        for (int i = 0; i < subschemas.size(); ++i) {
            Schema subschema = (Schema)subschemas.get(i);
            this.deleteType(ctx, scopedName + "." + i + ".", id, subschema, purge);
        }
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteNot(SchemaOperationContext ctx, String scope, int id, NotSchema schema, boolean purge) {
        String kind;
        String name = kind = "not";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, scopedName + ".", id, schema.getMustNotMatch(), purge);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteConditional(SchemaOperationContext ctx, String scope, int id, ConditionalSchema schema, boolean purge) {
        String kind;
        String name = kind = "conditional";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, scopedName + ".if.", id, (Schema)schema.getIfSchema().orElse(NullSchema.INSTANCE), purge);
        this.deleteType(ctx, scopedName + ".then.", id, (Schema)schema.getThenSchema().orElse(NullSchema.INSTANCE), purge);
        this.deleteType(ctx, scopedName + ".else.", id, (Schema)schema.getElseSchema().orElse(NullSchema.INSTANCE), purge);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteEmpty(SchemaOperationContext ctx, String scope, int id, EmptySchema schema, boolean purge) {
        String kind;
        String name = kind = "empty";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteFalse(SchemaOperationContext ctx, String scope, int id, FalseSchema schema, boolean purge) {
        String kind;
        String name = kind = "false";
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_COMBINED.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deletePrimitive(SchemaOperationContext ctx, String scope, String type, int id, Schema schema, boolean purge) {
        String name = type;
        String scopedName = scope + name;
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_PRIMITIVE.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteDefinitions(ctx, scopedName + ".", id, schema.getUnprocessedProperties(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }
}

