/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import io.confluent.catalog.hook.AtlasGraphUtils;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.hook.SchemaOperationContext;
import io.confluent.catalog.metrics.MetricsManager;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasMetricsUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=5)
@DependsOn(value={"atlasTypeDefStoreInitializer", "atlasTypeDefGraphStoreV2"})
public class SchemaAtlasProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAtlasProcessor.class);
    private static final Logger FAILED_LOG = LoggerFactory.getLogger((String)"FAILED");
    private static final int SC_OK = 200;
    private static final int SC_BAD_REQUEST = 400;
    private final KafkaSchemaRegistry schemaRegistry;
    private final AtlasEntityStore atlasEntityStore;
    private final AtlasInstanceConverter instanceConverter;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraphUtils atlasGraphUtils;
    private final MetricsManager metricsManager;
    private final int maxRetries = 3;
    private final int retryInterval = 500;
    private final int failedMsgCacheSize = 1;
    private final int commitBatchSize = 50;

    @Inject
    public SchemaAtlasProcessor(SchemaRegistry schemaRegistry, AtlasEntityStore atlasEntityStore, AtlasInstanceConverter instanceConverter, AtlasTypeRegistry typeRegistry, AtlasGraphUtils atlasGraphUtils, MetricsManager metricsManager) throws AtlasException {
        this.schemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
        this.atlasEntityStore = atlasEntityStore;
        this.instanceConverter = instanceConverter;
        this.typeRegistry = typeRegistry;
        this.atlasGraphUtils = atlasGraphUtils;
        this.metricsManager = metricsManager;
    }

    /*
     * Exception decompiling
     */
    void handleMessage(SchemaOperationContext ctx, HookNotification message, boolean initialized) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createOrUpdate(AtlasEntity.AtlasEntitiesWithExtInfo entities, boolean isPartialUpdate, AtlasMetricsUtil.NotificationStat stats) throws AtlasBaseException {
        List entitiesList = entities.getEntities();
        AtlasEntityStream entityStream = new AtlasEntityStream(entities);
        if (entitiesList.size() <= 50) {
            EntityMutationResponse response = this.atlasEntityStore.createOrUpdate((EntityStream)entityStream, isPartialUpdate);
            stats.updateStats(response);
            this.logEntityMutationResponse(response);
        } else {
            for (int fromIdx = 0; fromIdx < entitiesList.size(); fromIdx += 50) {
                int toIndex = fromIdx + 50;
                if (toIndex > entitiesList.size()) {
                    toIndex = entitiesList.size();
                }
                ArrayList entitiesBatch = new ArrayList(entitiesList.subList(fromIdx, toIndex));
                AtlasEntity.AtlasEntitiesWithExtInfo batch = new AtlasEntity.AtlasEntitiesWithExtInfo(entitiesBatch);
                AtlasEntityStream batchStream = new AtlasEntityStream(batch, (EntityStream)entityStream);
                EntityMutationResponse response = this.atlasEntityStore.createOrUpdate((EntityStream)batchStream, isPartialUpdate);
                stats.updateStats(response);
                this.logEntityMutationResponse(response);
                RequestContext.get().resetEntityGuidUpdates();
                RequestContext.get().clearCache();
            }
        }
    }

    private void logEntityMutationResponse(EntityMutationResponse response) {
        if (response == null) {
            return;
        }
        try {
            this.logSchemaEntityResponse(response.getCreatedEntities(), "Created");
            this.logSchemaEntityResponse(response.getUpdatedEntities(), "Updated");
            this.logSchemaEntityResponse(response.getDeletedEntities(), "Deleted");
            this.logSchemaEntityResponse(response.getPurgedEntities(), "Purged");
        }
        catch (Exception e) {
            LOG.error("Error logging EntityMutationResponse, should not have happened", (Throwable)e);
        }
    }

    private void logSchemaEntityResponse(List<AtlasEntityHeader> headers, String operation) {
        if (headers == null) {
            return;
        }
        headers.stream().filter(header -> SchemaAtlasTypes.SR_SUBJECT_VERSION.getName().equals(header.getTypeName())).forEach(header -> LOG.info("{} {} entity: {}", new Object[]{operation, SchemaAtlasTypes.SR_SUBJECT_VERSION.getName(), header.getAttribute("qualifiedName")}));
    }

    private void propagateTagsAndBMs(SchemaOperationContext ctx, AtlasEntity.AtlasEntitiesWithExtInfo entities) throws StoreException {
        SubjectKey subjectKey = ctx.getKey();
        if (!(subjectKey instanceof SchemaKey)) {
            return;
        }
        SchemaKey schemaKey = (SchemaKey)subjectKey;
        SchemaValue schemaValue = (SchemaValue)ctx.getValue();
        if (schemaKey.getVersion() == 1) {
            return;
        }
        SchemaKey previousSchemaKey = new SchemaKey(schemaKey.getSubject(), schemaKey.getVersion() - 1);
        SchemaValue previousSchema = (SchemaValue)this.schemaRegistry.getLookupCache().get((Object)previousSchemaKey);
        if (previousSchema == null || previousSchema.isDeleted()) {
            return;
        }
        int previousSchemaId = previousSchema.getId();
        int schemaId = schemaValue.getId();
        List entitiesList = entities.getEntities();
        for (AtlasEntity entity : entitiesList) {
            try {
                this.propagateEntityTagsAndBMs(ctx, entity, schemaKey, schemaId, previousSchemaId);
            }
            catch (AtlasBaseException e) {
                LOG.error("Failed to propagate tags for schema {}", (Object)schemaId, (Object)e);
            }
        }
    }

    private void propagateEntityTagsAndBMs(SchemaOperationContext ctx, AtlasEntity entity, SchemaKey schemaKey, int schemaId, int previousSchemaId) throws AtlasBaseException {
        Map businessAttributes;
        List previousTags;
        boolean propagateTags;
        SchemaAtlasTypes atlasType = SchemaAtlasTypes.valueOf(entity.getTypeName().toUpperCase());
        String qualifiedName = (String)entity.getAttribute("qualifiedName");
        Object[] parts = null;
        String previousQualifiedName = null;
        switch (atlasType) {
            case SR_SUBJECT_VERSION: {
                parts = QualifiedNameGenerator.parseQualifiedName(qualifiedName);
                if (parts.length <= 3) break;
                parts[3] = String.valueOf(schemaKey.getVersion() - 1);
                previousQualifiedName = QualifiedNameGenerator.getQualifiedName(parts);
                break;
            }
            case SR_SCHEMA: 
            case SR_RECORD: 
            case SR_FIELD: {
                parts = QualifiedNameGenerator.parseQualifiedName(qualifiedName);
                if (parts.length <= 2) break;
                parts[2] = String.valueOf(previousSchemaId);
                previousQualifiedName = QualifiedNameGenerator.getQualifiedName(parts);
                break;
            }
        }
        if (previousQualifiedName == null) {
            return;
        }
        Map<String, Object> attributes = Collections.singletonMap("qualifiedName", previousQualifiedName);
        AtlasEntityType entityType = this.ensureEntityType(entity.getTypeName());
        String previousGuid = null;
        try {
            previousGuid = this.getGuidByUniqueAttributes(entityType, attributes, AtlasEntity.Status.ACTIVE);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        if (previousGuid == null) {
            return;
        }
        boolean bl = propagateTags = ctx.getEmbeddedTags().isEmpty() && ctx.getNewVersion() == null || atlasType != SchemaAtlasTypes.SR_RECORD && atlasType != SchemaAtlasTypes.SR_FIELD;
        if (propagateTags && (previousTags = this.atlasEntityStore.getClassifications(previousGuid)) != null && !previousTags.isEmpty()) {
            List tags = previousTags.stream().map(previousTag -> {
                AtlasClassification tag = new AtlasClassification(previousTag);
                tag.setEntityGuid(entity.getGuid());
                return tag;
            }).collect(Collectors.toList());
            this.atlasEntityStore.addClassifications(entity.getGuid(), tags);
        }
        if ((businessAttributes = this.atlasEntityStore.getById(previousGuid).getEntity().getBusinessAttributes()) != null && !businessAttributes.isEmpty()) {
            this.atlasEntityStore.addOrUpdateBusinessAttributes(entity.getGuid(), businessAttributes, false);
        }
    }

    private AtlasEntityType ensureEntityType(String typeName) throws AtlasBaseException {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), typeName});
        }
        return ret;
    }

    private void recordFailedMessages(List<String> failedMessages) {
        for (String message : failedMessages) {
            FAILED_LOG.error("[DROPPED_NOTIFICATION] {}", (Object)message);
        }
        failedMessages.clear();
    }

    private boolean isEmptyMessage(HookNotification message) {
        boolean ret;
        switch (message.getType()) {
            case ENTITY_CREATE_V2: {
                AtlasEntity.AtlasEntitiesWithExtInfo entities = ((HookNotification.EntityCreateRequestV2)message).getEntities();
                ret = entities == null || CollectionUtils.isEmpty((Collection)entities.getEntities());
                break;
            }
            case ENTITY_FULL_UPDATE_V2: {
                AtlasEntity.AtlasEntitiesWithExtInfo entities = ((HookNotification.EntityUpdateRequestV2)message).getEntities();
                ret = entities == null || CollectionUtils.isEmpty((Collection)entities.getEntities());
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    @GraphTransaction(logRollback=false)
    public String getGuidByUniqueAttributes(AtlasEntityType entityType, Map<String, Object> attrValues, AtlasEntity.Status status) throws AtlasBaseException {
        return this.atlasGraphUtils.getGuidByUniqueAttributes(entityType, attrValues, status);
    }
}

